import QtQuick 1.0
// import com.nokia.meego 1.0

Item {
    property bool fullscreen: false
    property alias jm: jumpmodel
    id: bbar
    x: 0
    z: 100
    anchors.bottom: parent.bottom
    width: parent.width
    opacity: 1

    Rectangle {
        id: fontsizebutton
        anchors.left: parent.left
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 6
        anchors.leftMargin: 8
        width: 54
        height: 54
        radius: 5
        color: "transparent"
        opacity: 0.7
        Behavior on opacity { NumberAnimation { duration: 500 } }
        Image {
            anchors.centerIn: parent
            source: "images/fontsize.png"
        }
    }
    MouseArea {
        anchors.fill: fontsizebutton
        onClicked: {
            bbar.state = "";
            fader.restart();
            if (screen.fontsize < 10) {
                screen.fontsize += 2
            } else {
                screen.fontsize = -2
            }
        }
        onPressAndHold: {
            screen.fontsize = 0
            bbar.state = "";
            fader.restart();
        }

        onPressed: {
            fontsizebutton.color = "lightgrey"
            bbar.state = "";
            fader.restart();

        }
        onReleased:  {
            fontsizebutton.color = "transparent"
            bbar.state = "";
            fader.restart();
        }
    }


    Rectangle {
        id: fullscreenbutton
        anchors.right: parent.right
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 6
        anchors.rightMargin: 8
        width: 54
        height: 54
        radius: 5
        color: "transparent"
        opacity: 0.7
        Behavior on opacity { NumberAnimation { duration: 500 } }
        Image {

            anchors.centerIn: parent
            source: "images/general_fullsize.png"
        }
    }
    MouseArea {
        anchors.fill: fullscreenbutton
        onClicked: {
            bbar.state = "";
            fader.restart();
            if (bbar.fullscreen) {
                bbar.fullscreen = false
                window.fullscreen(false)
            } else {
                bbar.fullscreen = true
                window.fullscreen(true)
            }
        }
        onPressed: {
            fullscreenbutton.color = "lightgrey"
            bbar.state = "";
            fader.restart();
        }
        onReleased:  {
            fullscreenbutton.color = "transparent"
            bbar.state = "";
            fader.restart();
        }
    }
    Rectangle {
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 0
        width: parent.width - 128
        height: 24
        color: "transparent"
        MouseArea {
            anchors.fill: parent
            onPressed: {
                bbar.state = "";
            }
        }

        ListView {
            z: 1
            Behavior on opacity { NumberAnimation { duration: 500 } }
            // anchors.fill: parent
            interactive: false
            opacity: 0.8
            anchors.centerIn: parent
            width: (32 * jumpmodel.count)
            height: 36
            id: jumplist
            model: jumpmodel
            orientation: ListView.Horizontal

            delegate: Rectangle {
                id: jumpbutton
                y: 0
                width: 32
                height: 36
                color: "transparent"
                opacity: 1
                Image {
                    y: 2
                    id: sqr
                    anchors.horizontalCenter: parent.horizontalCenter
                    source: "images/tinysqr.png"
                }

                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        // console.log(375*index)
                        bbar.state = "";
                        fader.restart();
                        mainrow.contentX = (window.columnwidth * index);
                    }
                    onPressed: {
                        bbar.state = "";
                        fader.restart();
                        sqr.source = "images/tinysqr2.png";
                    }
                    onReleased: {
                        bbar.state = "";
                        fader.restart();
                        sqr.source = "images/tinysqr.png";
                    }
                }
            }
        }
    }
    ListModel {
        id: jumpmodel
    }
    states: [
        State {
            name: "hidden"
            PropertyChanges {
                target: fontsizebutton
                opacity: 0.1
            }
            PropertyChanges {
                target: fullscreenbutton
                opacity: 0.1
            }
            PropertyChanges {
                target: jumplist
                opacity: 0.4
            }
        }
    ]
    Timer {
        id: fader
        interval: 15000
        running: true; repeat: false
        onTriggered: bbar.state = "hidden";
    }
}
