import QtQuick 1.0

Item {
    id: langlist
    anchors.fill: parent;
    ListModel {
        id: langModel
    }
    ListView {
        anchors.fill: parent
        model: langModel
        delegate: langDelegate
        highlight: Rectangle { color: "lightsteelblue"; radius: 5 }
    }

    Component {
        id: langDelegate
        Item {
            width: childrenRect.width
            height: childrenRect.height
            Text {
                text: name + "(" + language + ")";
                font.pointSize: 12
            }
            MouseArea {
                anchors.fill: parent;
                onClicked: {
                    setLang(language, name);
                }
            }
        }
    }
    Component.onCompleted: {
        var langs = screen.js().getLangList();
        console.log("LANGLENGTH: "+ langs.length);
        for (var i = 0; i < langs.length; i++) {
            langModel.append(langs[i]);
        }

    }
    function setLang(lang, name) {
        authBox.langtext = name
        screen.js().translang = lang;
        storage.storeSetting("lang", lang, screen.js().twitterusername);
    }
}
