import QtQuick 1.0
Component {
    id: aRowDelegate
    Item {
        id: root
        property string rowtype: type
        property string searchphrase: search
        property int position: posit
        property int timeoutInSeconds: timeout
        property int notifyable: notify;
        property string oldtime: "0";
        property bool refreshing: false;
        property alias searchModel: searchModel
        property int loadid: index
        
        function getColumnText() {
            if (rowtype == "user") {
                var data = searchModel.model.get(0);
                if (data) {
                    var txt = '<html><style type="text/css">a:link {color:"#a0a0ff"}; a:visited {color:"#0000ee"}</style>'
                        + "<font size=+1><b>" + data.longname + '</b></font><br /><a href="http://twitter.com/' + data.name + '">@'
                        + data.name + '</a> '
                        if (data.following == "true") txt += "(Following)";
                        txt += '<p>'
                        + data.description + '<p>'
                        + 'Followers: ' + data.followers + '  Following: ' + data.friends
                        + '<br />Tweets: ' + data.tweets
                        + '</html>'
                    return txt;

                } else return "Loading...";
            } else {
                return "Column name: " + searchphrase
                        + "<br />\nColumn type: " + rowtype
                        + "<br />\nRefresh rate: " + timeoutInSeconds + " seconds"
                        + "<br />\nNotify: " + notifyable;
            }
        }

        ListView.onRemove: SequentialAnimation {
            PropertyAction { target: root; property: "ListView.delayRemove"; value: true }
            ScriptAction {
                script: {
                    bottombar.jm.remove(index);
                }
            }
            NumberAnimation { target: root; property: "opacity"; to: 0; duration: 250; easing.type: Easing.InOutQuad }
            NumberAnimation { target: root; property: "width"; to: 0; duration: 250; easing.type: Easing.InOutQuad }
            PropertyAction { target: root; property: "ListView.delayRemove"; value: false }

        }
        ListView.onAdd: {
            console.log("ONADD SCRIPT!!!!!")
            // bottombar.jm.append({ index: index });
            mainrow.contentX = 375*(mainrow.count-2);

        }
            // NumberAnimation { target: mainrow; property: "contentX"; to: 375*(mainrow.count-2); duration: 250; }
        height: parent.height;
        width: 375
        Column {
            function doRefresh() {
                // Search ! allowed
                // searchModel.phrase = queryText.text;
                // console.log("phrase = " + queryIn1.text)
                topbar.state = "loading"
                searchModel.manualReload();
            }
            function doRemove() {
                // Search ! allowed
                screen.removeColumn(index, position)
                //mainrowModel.remove(index)
            }

            function moveColumn(dir) {
                console.log("ping")
                console.log(dir)
                switch (dir) {
                    case "left":
                        if (index > 0) {
                        // ;
                            console.log("!")
                            console.log("pos1: " + mainrowModel.get(index).posit);
                            console.log("pos2: " + mainrowModel.get(index - 1).posit);
                            storage.switchPosit(mainrowModel.get(index).posit, mainrowModel.get(index - 1).posit);
                            var tmp = mainrowModel.get(index).posit;
                            mainrowModel.get(index).posit = mainrowModel.get(index - 1).posit;
                            mainrowModel.get(index - 1).posit = tmp;
                            mainrowModel.move(index, index - 1, 1);
                        // console.log("pos2: " + mainrowModel.get(index - 1).position);
                        }
                    break;
                    case "right":
                        console.log("right chosen")
                        console.log(index + " -- " +mainrowModel.count)
                        if (index < mainrowModel.count - 1) {
                        // ;
                            console.log("!")
                            console.log("pos1: " + mainrowModel.get(index).posit);
                            console.log("pos2: " + mainrowModel.get(index + 1).posit);
                            storage.switchPosit(mainrowModel.get(index).posit, mainrowModel.get(index + 1).posit);
                            var temp = mainrowModel.get(index).posit;
                            mainrowModel.get(index).posit = mainrowModel.get(index + 1).posit;
                            mainrowModel.get(index + 1).posit = temp;
                            mainrowModel.move(index, index + 1, 1);
                        // console.log("pos2: " + mainrowModel.get(index - 1).position);
                        } 
                    break;
                }
            }

            id: aSearchColumn
            TopBar {
                id: topbar
                x: 1
                bgimage: screen.js().getBgSource(rowtype)
                headline: search
                onCloseClicked: { aSearchColumn.doRemove() }
                onRefreshClicked: { aSearchColumn.doRefresh() }
                onMoverightClicked: { aSearchColumn.moveColumn("right") }
                onMoveleftClicked: { aSearchColumn.moveColumn("left") }
                onMainClicked: { console.log("items in model now: " + searchModel.model.count); }
                infotext: getColumnText()
            }

            Rectangle {
                width: 375
                height: root.height - topbar.height
                color: "transparent"
                //border.width: 0
                anchors.margins: 10
                clip: true
                // The delegate for each section header

                FeedDelegate { id: feedDelegate; }

                TwitterApiModel { id: searchModel; phrase: searchphrase; mode: rowtype; timeout: timeoutInSeconds; notify: notifyable;
                    onStatusDone: {
                        // console.log("items in model: " + searchModel.model.count);
                        if (!screen.js().loadedcols[index]){
                            screen.js().loadedcols[index] = true;
                            // searchModel.model.reload();
                            topbar.state = "";
                            //console.log("items in model after reload: " + searchModel.model.count);
                        } else {
                            refreshing = false;
                            if (searchModel.apioverload) topbar.state = "apioverload";
                            else topbar.state = "";
                            if (rowtype != "rss") {
                                searchList.positionViewAtIndex(searchList.count - 15, ListView.Contain);
                            }
                            if (rowtype == "user") {
                                topbar.infotext = getColumnText();
                            }

                            // ** notify if notification enabled
                            if (searchModel.autoref && notifyable > 0 && searchModel.model.count > 0) {
                                if ("" + screen.js().getUnixtime(searchModel.model.get(0).timestamp) != oldtime) {
                                    console.log("**NOTIFY** " + searchphrase);
                                    Notty.notify("Tweed Suit", "New  " + searchphrase);
                                }
                            }
                            if (searchModel.model.count > 0) oldtime = "" + screen.js().getUnixtime(searchModel.model.get(0).timestamp, rowtype);
                        }
                    }
                }
                Footer { id: theFooter }
                ListView {
                    property bool scrolled
                    // cacheBuffer: 1000
                    id: searchList
                    anchors.fill: parent
                    model: searchModel.model
                    delegate: feedDelegate
                    footer: theFooter
                    boundsBehavior: Flickable.DragOverBounds
                    onContentYChanged: {
                        if (loading.state == "hidden" && searchList.cacheBuffer == 0) {
                            console.log("Setting cachebuffer for index " + index + " to 1000");
                            searchList.cacheBuffer = 1000;
                        }

                        if (contentY < -50 && !refreshing) {
                            refreshing = true;
                            aSearchColumn.doRefresh();
                        }
                    }
                    onMovementEnded: refreshing = false;
                }

            }
        }
/*        Gradient {
            id: bar
            GradientStop { position: 0.0; color: "white" }
            GradientStop { position: 0.1; color: "lightgrey" }
             GradientStop { position: 0.9; color: "darkgrey" }
            GradientStop { position: 1.0; color: "black" }
        }
        Gradient {
            id: boxgrad
            GradientStop { position: 0.0; color: "#252525" }
            GradientStop { position: 1.0; color: "#484848" }
        } */
    }
}
