import QtQuick 1.0

Item {
    property bool fullscreen: false
    property alias jm: jumpmodel
    id: bbar
    x: 0
    z: 100
    anchors.bottom: parent.bottom
    width: parent.width
    opacity: 1
    Behavior on opacity { NumberAnimation { duration: 100 } }

    Rectangle {
        id: fontsizebutton
        anchors.left: parent.left
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 6
        anchors.leftMargin: 8
        width: 54
        height: 54
        radius: 5
        color: "transparent"
        opacity: 0.7
        Image {
            anchors.centerIn: parent
            source: "images/fontsize.png"
        }
    }
    MouseArea {
        anchors.fill: fontsizebutton
        onClicked: {
            bbar.state = "";
            fader.restart();
            if (screen.fontsize < 10) {
                screen.fontsize += 2
            } else {
                screen.fontsize = -2
            }
        }
        onPressAndHold: {
            screen.fontsize = 0
            bbar.state = "";
            fader.restart();
        }

        onPressed: {
            fontsizebutton.color = "lightgrey"
            bbar.state = "";
            fader.restart();

        }
        onReleased:  {
            fontsizebutton.color = "transparent"
            bbar.state = "";
            fader.restart();
        }
    }


    Rectangle {
        id: fullscreenbutton
        anchors.right: parent.right
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 6
        anchors.rightMargin: 8
        width: 54
        height: 54
        radius: 5
        color: "transparent"
        opacity: 0.7
        Image {

            anchors.centerIn: parent
            source: "images/general_fullsize.png"
        }
    }
    MouseArea {
        anchors.fill: fullscreenbutton
        onClicked: {
            bbar.state = "";
            fader.restart();
            if (bbar.fullscreen) {
                bbar.fullscreen = false
                View.showNormal();
            } else {
                bbar.fullscreen = true
                View.showFullScreen();
            }
        }
        onPressed: {
            fullscreenbutton.color = "lightgrey"
            bbar.state = "";
            fader.restart();
        }
        onReleased:  {
            fullscreenbutton.color = "transparent"
            bbar.state = "";
            fader.restart();
        }
    }
    Rectangle {
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 3
        width: parent.width - 128
        height: 50
        color: "transparent"

        ListView {
            // anchors.fill: parent
            anchors.centerIn: parent
            width: contentWidth
            height: contentHeight
            id: jumplist
            model: jumpmodel
            orientation: ListView.Horizontal
            delegate: Rectangle {
                id: jumpbutton

                width: 24
                height: 48
                color: "transparent"
                opacity:  0.7
                Image {
                    id: sqr
                    anchors.horizontalCenter: parent.horizontalCenter
                    source: "images/tinysqr.png"
                }

                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        // console.log(375*index)
                        bbar.state = "";
                        fader.restart();
                        mainrow.contentX = (375*index);
                    }
                    onPressed: {
                        bbar.state = "";
                        fader.restart();
                        sqr.source = "images/tinysqr2.png";
                    }
                    onReleased: {
                        bbar.state = "";
                        fader.restart();
                        sqr.source = "images/tinysqr.png";
                    }
                }
            }
        }
    }
    ListModel {
        id: jumpmodel
    }
    states: [
        State {
            name: "hidden"
            PropertyChanges {
                target: bbar
                opacity: 0.1
            }
        }
    ]
    Timer {
        id: fader
        interval: 8000
        running: true; repeat: false
        onTriggered: bbar.state = "hidden";
    }
}
