import QtQuick 1.0
Component {

    id: aRowDelegate
    Item {
        id: root
        property string rowtype: type
        property string searchphrase: search
        property int position: posit
        property int timeoutInSeconds: timeout
        property int notifyable: notify;
        property string oldtime: "0";
        property bool refreshing: false;
        
        function getColumnText() {
            if (rowtype == "user") {
                var data = searchModel.model.get(0);
                if (data) {
                    var txt = '<html><style type="text/css">a:link {color:"#a0a0ff"}; a:visited {color:"#0000ee"}</style>'
                        + "<font size=+1><b>" + data.longname + '</b></font><br /><a href="http://twitter.com/' + data.name + '">@'
                        + data.name + '</a> '
                        if (data.following == "true") txt += "(Following)";
                        txt += '<p>'
                        + data.description + '<p>'
                        + 'Followers: ' + data.followers + '  Following: ' + data.friends
                        + '<br />Tweets: ' + data.tweets
                        + '</html>'
                    return txt;

                } else return "Loading...";
            } else {
                return "Column name: " + searchphrase
                        + "<br />\nColumn type: " + rowtype
                        + "<br />\nRefresh rate: " + timeoutInSeconds + " seconds"
                        + "<br />\nNotify: " + notifyable;
            }
        }

        ListView.onRemove: SequentialAnimation {
            PropertyAction { target: root; property: "ListView.delayRemove"; value: true }
            NumberAnimation { target: root; property: "opacity"; to: 0; duration: 250; easing.type: Easing.InOutQuad }
            NumberAnimation { target: root; property: "width"; to: 0; duration: 250; easing.type: Easing.InOutQuad }
            PropertyAction { target: root; property: "ListView.delayRemove"; value: false }
        }
        ListView.onAdd: NumberAnimation { target: mainrow; property: "contentX"; to: 375*(mainrow.count-2); duration: 250; }
        height: parent.height;
        width: 375
        Column {
            function doRefresh() {
                // Search ! allowed
                // searchModel.phrase = queryText.text;
                // console.log("phrase = " + queryIn1.text)
                topbar.state = "loading"
                searchModel.manualReload();
            }
            function doRemove() {
                // Search ! allowed
                screen.removeColumn(index, position)
                //mainrowModel.remove(index)
            }

            function moveColumn(dir) {
                console.log("ping")
                console.log(dir)
                switch (dir) {
                    case "left":
                        if (index > 0) {
                        // ;
                            console.log("!")
                            console.log("pos1: " + mainrowModel.get(index).posit);
                            console.log("pos2: " + mainrowModel.get(index - 1).posit);
                            storage.switchPosit(mainrowModel.get(index).posit, mainrowModel.get(index - 1).posit);
                            var tmp = mainrowModel.get(index).posit;
                            mainrowModel.get(index).posit = mainrowModel.get(index - 1).posit;
                            mainrowModel.get(index - 1).posit = tmp;
                            mainrowModel.move(index, index - 1, 1);
                        // console.log("pos2: " + mainrowModel.get(index - 1).position);
                        }
                    break;
                    case "right":
                        console.log("right chosen")
                        console.log(index + " -- " +mainrowModel.count)
                        if (index < mainrowModel.count - 1) {
                        // ;
                            console.log("!")
                            console.log("pos1: " + mainrowModel.get(index).posit);
                            console.log("pos2: " + mainrowModel.get(index + 1).posit);
                            storage.switchPosit(mainrowModel.get(index).posit, mainrowModel.get(index + 1).posit);
                            var tmp = mainrowModel.get(index).posit;
                            mainrowModel.get(index).posit = mainrowModel.get(index + 1).posit;
                            mainrowModel.get(index + 1).posit = tmp;
                            mainrowModel.move(index, index + 1, 1);
                        // console.log("pos2: " + mainrowModel.get(index - 1).position);
                        } 
                    break;
                }
            }

            id: aSearchColumn
/*            Rectangle {
                id: controlBar
                width: 373
                x: 1
                // anchors.leftMargin: 1
                // anchors.rightMargin: 1
                height: childrenRect.height
                color: "grey"
                Row {
                    z: 1
                    Rectangle {
                        // anchors.verticalCenter: controlBar.verticalCenter
                        // color: "lightgrey"
                        id: logo
                        gradient: bar
                        width: twitterlogo.width + 6
                        height: refreshbuttoncontainer.height
                        Image { x: 3; y: ((parent.height - height) / 2) - 1; id: twitterlogo; source: if (rowtype != "rss") "images/twitter_t_logo_small.png"; else "images/rss_small.png" }
                    }
                    Rectangle {
                        // anchors.verticalCenter: controlBar.verticalCenter
                        // color: "lightgrey"
                        clip: true;
                        gradient: bar
                        width: controlBar.width - logo.width - refreshbuttoncontainer.width - removebuttoncontainer.width
                        height: refreshbuttoncontainer.height
                        Text { x: 2; y: ((parent.height - height) / 2) - 1; id: queryText; font.pointSize: 16; text: search; clip: true }
                    }
                    Rectangle {
                        id: refreshbuttoncontainer
                        //anchors.verticalCenter: controlBar.verticalCenter
                        // color: "lightgrey"
                        gradient: bar
                        width: refreshbutton.width + 10
                        height: refreshbutton.height + 6
                        Button {
                            anchors.centerIn: parent
                            id: refreshbutton
                            // width: childrenRect.width + 10
                            // height: childrenRect.height + 10
                            text: "Reload"
                            onClicked: refreshbutton.doRefresh();
                            function doRefresh() {
                                // Search ! allowed
                                // searchModel.phrase = queryText.text;
                                // console.log("phrase = " + queryIn1.text)
                                loadingText.state = "opened"
                                searchModel.manualReload();
                            }
                        }
                    }
                    Rectangle {
                        // anchors.verticalCenter: controlBar.verticalCenter
                        //color: "lightgrey"
                        gradient: bar
                        id: removebuttoncontainer
                        width: removebutton.width + 10
                        height: removebutton.height + 6
                        Button {
                            anchors.centerIn: parent
                            id: removebutton
                            // width: childrenRect.width + 10
                            // height: childrenRect.height + 10
                            text: "X"
                            onClicked: removebuttoncontainer.doRemove();

                        }

                        function doRemove() {
                            // Search ! allowed
                            screen.removeColumn(index, position)
                            //mainrowModel.remove(index)
                        }
                    }



                }
                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        if (optionBox.state == "opened") optionBox.state = "closed";
                        else optionBox.state = "opened"
                    }
                }

            }

            Rectangle {
                id: optionBox
                color: "black";
                width: parent.width - 2
                x: 1
                height: 0
                clip: true
                gradient: boxgrad
                opacity: 1

                Text {
                    id: iText
                    x: 10
                    color: "white";
                    width: parent.width - 20;
                    anchors.verticalCenter: parent.verticalCenter
                    text: "Column name: " + searchphrase
                    + "\nColumn type: " + rowtype
                    + "\nRefresh rate: " + timeoutInSeconds + " seconds"
                    + "\nNotify: " + notifyable;
                    font.pointSize: 12
                    // font.weight: Font.Bold
                    wrapMode: Text.WordWrap
                    onLinkActivated: Qt.openUrlExternally(link)
                }
                states: [
                    State {
                        name: "opened"
                        PropertyChanges { target: optionBox; height: iText.height + 10; }
                    },
                    State {
                        name: "closed"
                        PropertyChanges { target: optionBox; height: 0; }
                    }
                ]
                transitions: Transition { NumberAnimation { target: optionBox; property: "height"; duration: 100 } }
            }


            Rectangle {
                id: loadingText
                color: "black";
                width: parent.width-2
                x: 1
                height: 0
                clip: true
                gradient: boxgrad
                opacity: 1

                Image {
                    anchors.fill: parent
                    source: "images/tweed_bg.png"
                    fillMode: Image.Tile
                    opacity: 0.5
                }
                states: [
                    State {
                        name: "opened"
                        when: searchModel.status == XmlListModel.Loading
                        PropertyChanges { target: loadingText; height: 51; }
                    },
                    State {
                        name: "closed"
                        when: searchModel.status != XmlListModel.Loading
                        PropertyChanges { target: loadingText; height: 0; }
                    }
                ]
                transitions: Transition { NumberAnimation { target: loadingText; property: "height"; duration: 100 } }
                Text {
                    text: "Loading"
                    font.pointSize: 15
                    anchors.centerIn: parent
                }

            } */

            TopBar {
                id: topbar
                x: 1
                bgimage: screen.js().getBgSource(rowtype)
                headline: search
                onCloseClicked: { aSearchColumn.doRemove() }
                onRefreshClicked: { aSearchColumn.doRefresh() }
                onMoverightClicked: { aSearchColumn.moveColumn("right") }
                onMoveleftClicked: { aSearchColumn.moveColumn("left") }
                infotext: getColumnText()
            }

            Rectangle {
                width: 375
                height: root.height - topbar.height
                color: "transparent"
                //border.width: 0
                anchors.margins: 10
                clip: true
                // The delegate for each section header

                FeedDelegate { id: feedDelegate; }

                TwitterApiModel { id: searchModel; phrase: searchphrase; mode: rowtype; timeout: timeoutInSeconds; notify: notifyable  }
                Footer { id: theFooter }
                ListView {
                    property bool scrolled
                    cacheBuffer: 1000
                    id: searchList
                    anchors.fill: parent
                    model: searchModel.model
                    delegate: feedDelegate
                    footer: theFooter
                    boundsBehavior: Flickable.DragOverBounds
                    onContentYChanged: {
                        if (contentY < -50 && !refreshing) {
                            refreshing = true;
                            aSearchColumn.doRefresh();
                        }
                    }
                    onMovementEnded: refreshing = false;
                    states: [
                        State {
                            name: "allLoaded"
                            when: searchModel.model.status == XmlListModel.Ready
                            StateChangeScript { script: {
                                    refreshing = false;
                                    if (searchModel.apioverload) topbar.state = "apioverload";
                                    else topbar.state = "";
                                    if (rowtype != "rss") searchList.positionViewAtIndex(searchList.count - 15, ListView.Contain);
                                    if (rowtype == "user") {
                                        topbar.infotext = getColumnText();
                                    }

                                    if (searchModel.autoref) {
                                        console.log("autoref - yes");
                                        if (notifyable > 0) {
                                            console.log("notify - yes")
                                            if (searchModel.model.count > 0) {
                                                console.log("count > 0");
                                                if ("" + screen.js().getUnixtime(searchModel.model.get(0).timestamp) != oldtime) {
                                                    console.log(screen.js().getUnixtime(searchModel.model.get(0).timestamp, rowtype) + " != " + oldtime);
                                                    console.log("**NOTIFY** " + searchphrase);
                                                    Notty.notify("Tweed Suit", "New  " + searchphrase);
                                                } else {
                                                    console.log(screen.js().getUnixtime(searchModel.model.get(0).timestamp, rowtype) + " == " + oldtime + " so no notify");
                                                }
                                            }
                                        }
                                    }
                                    if (searchModel.model.count > 0) oldtime = "" + screen.js().getUnixtime(searchModel.model.get(0).timestamp, rowtype);
                                }
                            }

                        }

                    ]


                }
/*                Component.onCompleted: function () {
                    if (type == "search") {

                    } else if (type == "user") {

                    } */
            }
        }
        Gradient {
            id: bar
            GradientStop { position: 0.0; color: "white" }
            GradientStop { position: 0.1; color: "lightgrey" }
            //GradientStop { position: 0.1; color: "#33ccff" }
             GradientStop { position: 0.9; color: "darkgrey" }
             //GradientStop { position: 0.9; color: "lightgrey" }
            GradientStop { position: 1.0; color: "black" }
        }
        Gradient {
            id: boxgrad
            GradientStop { position: 0.0; color: "#252525" }
            GradientStop { position: 1.0; color: "#484848" }
        }
    }
}
