import QtQuick 1.0
Component {
     id: listDelegate


    Rectangle {
        property string mode: ListView.view.model.modelType
         id: wrapper; width: wrapper.ListView.view.width
         height: if(txt.height > 50){txt.height+10 + tweetButtons.height}else{60 + tweetButtons.height}   //50+5+5
         color: "transparent"
         function handleLink(link){
             if (link.slice(0,3) == 'app') {
                 screen.addNewTwitterColumn(link.slice(6), "search", 0, 0);
             } else if (link.slice(0,3) == 'usr') {
                 screen.addNewTwitterColumn(link.slice(7), "user", 0, 0);
             } else if (link.slice(0,3) == 'irt') {
                 screen.addNewTwitterColumn(link.slice(6), "single", 0, 0);
             } else if (link.slice(0,4) == 'http') {
                 Qt.openUrlExternally(link);
             }
         }
         function addTags(str) {
             var ret = str.replace(/@[a-zA-Z0-9_]+/g, '<a href="usr://$&">$&</a>');//click to jump to user?
             var ret = ret.replace(/(^|\s)(#[a-zA-Z0-9_]+)/g, '$1<a href="app://$2">$2</a>');//click to jump add search?
             var ret = ret.replace(/https?:\/\/[^ \n\t]+/g, '<a href="$&">$&</a>');//surrounds http links with html link tags
             return ret;
         }

         // Strip away paranthesis
         function userName(str) {
             var user = str.replace(/\([\S|\s]*\)/gi, "");
             return user.trim();
         }

         function getId(str) {
             if (str.split("/").length > 1) {
                 var tmp = str.split("/");
                 return tmp[5];
             } else return str;
         }

         function replyTo(u, t) {
             tweetBox.inReplyTo = t;
             tweetBox.state = "open";
             tweetBox.tweetText += "@" + u + " ";
         }
         function retweetOld(u, t, s) {
             tweetBox.inReplyTo = t;
             tweetBox.state = "open";
             tweetBox.tweetText = "RT @" + u + ": " + s;
         }

         function dmTo(u) {
             tweetBox.state = "open";
             tweetBox.tweetText = "D @" + u + " ";
         }

         function tweetThis(t, l) {
             tweetBox.state = "open";
             tweetBox.tweetText = t + ": " + l;
         }

        function getTs(t) {
            var tmp = t;
            if (mode == 'search') tmp = screen.js().convertFromAtom(t);
            // console.log("datetime: " + tmp);
            var ts = new Date(tmp)
            return ts.toLocaleString();
         }

        function fetchGoogleTranslate(lang) {
            var lang = (lang)?lang:"en";
            var xhrz = new XMLHttpRequest
            xhrz.open("GET", screen.js().getTranslateUrl(statusText, lang));
            xhrz.onreadystatechange = function() {
                if (screen.js().getTranslatedText(xhrz)) {
                    console.log("translation is done.");
                    txt.text =  getText(screen.js().getTranslatedText(xhrz));
                }
            }
            xhrz.send()

            // txt.text = getText(screen.js().googleTranslate(statusText));
        }

         function getText(t) {
             var stTxt = (t)?t:statusText;
             // console.log("mode is " + mode + " and phrase is\n" + ListView.view.model.searchText );
             var ret = '';
             if (mode != 'rss') {
                 if (mode != 'dm') {
                     ret = '<html><style type="text/css">a:link {color:"#66d0ff"; text-decoration: none}; a:hover {text-decoration: underline}; a:visited {color:"#a0a0a0"}</style>'
                         + "" + addTags(stTxt) + "</html>"
                         + '<br /> <font size="-2">By <a href="usr://@'+userName(name)+'"><b>'+userName(name) + "</b></a>"
                         + " using " +source + "</font>";
                 } else {
                     ret = '<html><style type="text/css">a:link {color:"#66d0ff"; text-decoration: none}; a:hover {text-decoration: underline}; a:visited {color:"#a0a0a0"}</style>'
                         + '<b><font size="-1">Direct Message to <a href="usr://@'+userName(recipientname)+'">' + userName(recipientname) + '</b></a></font><br />' + addTags(stTxt)
                         + '<br />From <a href="usr://@'+userName(name)+'"><b>'+userName(name) + "</b></a></html>";
                 }
             } else {
                 ret = '<html><style type="text/css">a:link {color:"#66d0ff"; text-decoration: none}; a:hover {text-decoration: underline}; a:visited {color:"#a0a0a0"}</style>'
                     + '<a href="' + link + '"><b>' + title + '</b></a><br />'
                     + '<font size="-2">' + (stTxt.stripTags()).slice(0,200);
                 if (stTxt.stripTags().length > 200) ret += ' ...';
                 ret += '<br /> at ' + getTs(timestamp) + '</b></font></html>';
             }

             return ret

         }


         function getMoreText(t) {
             var stTxt = (t)?t:statusText;
             var ret = '';
             if (mode != 'rss') {
                 ret = '<html><style type="text/css">a:link {color:"#66d0ff"; text-decoration: none}; a:hover {text-decoration: underline}; a:visited {color:"#a0a0a0"}</style>'
                     + '<font size="-1">posted ' +  getTs(timestamp) + '</font>';
                     if (mode != 'search' && inReplyToId != undefined && inReplyToId.length > 0) ret += ' <br /><a href="irt://' + inReplyToId + '">In reply to ...</a></html>';
                     else ret += "</html>";
             } else {
                 if (stTxt.stripTags().length > 200) ret = '<html><style type="text/css">a:link {color:"#66d0ff"; text-decoration: none}; a:hover {text-decoration: underline}; a:visited {color:"#a0a0a0"}</style>'
                     + '<font size="-2">... ' + (stTxt.stripTags()).slice(200) + '</font>'
             }

             return ret
         }

         function getImage() {
             if (mode != 'rss') {
                 return userImage;
             } else {
                 image.width = 0;
                 // realImage.width = 0;
                 return "";
             }
         }

         function getBigImage() {
             if (mode != 'rss') {
                 var i = 3;
                 var end = userImage.slice(userImage.length - i);
                 while (end.slice(0,1) != ".") {
                     i++;
                     var slicebit = userImage.length - i
                     if (slicebit <= 0) return "";
                     end = userImage.slice(slicebit)
                 }

                console.log(end);
                var ret = userImage.slice(0, userImage.length - 7 - i) + end;
                console.log(ret);
                return ret
             } else {
                 return "";
             }
         }

        function setButtons() {
            if (mode != "rss") {
                if (mode == "home") {
                    button4.destroy(); // no follow needed in home
                }
            } else {
                button0.text = "Tweet this"
                // button0.onClicked = tweetThis(title, link);
                button1.destroy();
                button4.destroy();
                button5.destroy();
                button6.destroy();

            }
        }
        function clickedButton(n) {
            switch (n) {
                case 0:
                    if (mode != "rss") {
                        replyTo(userName(name), getId(tweetId));
                    } else {
                        tweetThis(title, link);
                    }

                break;
                case 1:
                    if (mode != "rss") {
                        retweetOld(userName(name), getId(tweetId), statusText);
                    }

                break;
                case 2: // more button
                    if (tweetButtons.state != "fullyopened") {
                        tweetButtons.state = "fullyopened"
                    } else {
                        tweetButtons.state = "opened"
                    }
                break;
                case 3:
                    fetchGoogleTranslate();
                break;
                case 4:
                    screen.js().follow(userName(name));
                break;
                case 5: // unfollow
                    screen.js().unFollow(userName(name));
                break;
                case 6: // unfollow
                    dmTo(userName(name));
                break;

            }
        }

         Item {
             id: moveMe; height: parent.height
             Rectangle {
                 y: 0; x: 1;
                 height: 1; width: wrapper.width-2;
                 color: "#606060"
             }

             Rectangle {
                id: blackRect
                color: "#383838";
                height: wrapper.height-2; width: wrapper.width-2;
                y: 1; x: 1
                
             }
             Item {
                id: image;
                x: 6; y: 6; z: 1;
                width: 48; height: 48;
                smooth: true

                Image {
                    id: realImage;
                    source: getImage(); x: 1; y: 1;
                    width:48; height:48; opacity:1;
                    scale: 0
                    // asynchronous: true
                    onStatusChanged: {
                        if (status == Image.Ready)
                            image.state = "loaded";
                        else if (status == Image.Error) {
                            loadingpic.opacity = 0;
                            loadingpic.source = "";
                        }

                    }
                    Behavior on scale { NumberAnimation { duration: 200 } }
                    MouseArea {
                        anchors.fill: parent
                        onClicked: screen.js().viewImage(getBigImage())
                    }
                }
                AnimatedImage {
                    id: loadingpic
                    anchors.centerIn: parent
                    source: (mode == 'rss') ? "" : "images/loading_circle.gif"
                }

                states: State {
                    name: "loaded";
                    PropertyChanges { target: loadingpic ; opacity: 0 }
                    PropertyChanges { target: loadingpic ; source: "" }
                    PropertyChanges { target: realImage ; scale:1 }
                }
            }

            Text {
                id: txt
                x: 56; y:4; z: 1
                font.pointSize: 12 + screen.fontsize
                text: getText()
                color: "white"; wrapMode: Text.Wrap
                anchors.left: image.right
                anchors.right: blackRect.right
                anchors.leftMargin: 6
                anchors.rightMargin: 6
                onLinkActivated: wrapper.handleLink(link)
            }
            MouseArea {
                anchors.fill: blackRect
                onClicked: {
                    if (tweetButtons.state != "") tweetButtons.state = ""
                    else tweetButtons.state = "opened"
                }
            }
            Rectangle {
                id: tweetButtons
                color: "black";
                width: wrapper.width - 2; height: childrenRect.height + 1;
                x: 1; y: wrapper.height - height
                clip: true
                states: [
                    State {
                        name: "opened"
                        PropertyChanges { target: button2; text: "More..."}
                        PropertyChanges { target: mainmore; height: childrenRect.height - evenMoreButtons.height - 6; opacity: 1}

                    },
                    State {
                        name: "fullyopened"
                        PropertyChanges { target: button2; text: "Less..."}
                        PropertyChanges { target: mainmore; height: childrenRect.height; opacity: 1}

                    }
                ]
                transitions: [
                    Transition { NumberAnimation { target: mainmore; property: "height"; duration: 100 } }
                ]




                Rectangle {
                    id: mainmore
                    x: 0; y: 0;
                    height: 0; width: wrapper.width-2;
                    // color: "#484848"
                    gradient: Gradient {
                        GradientStop { position: 0.0; color: "#666" }
                        GradientStop { position: 1.0; color: "#eee" }
                    }
                    opacity: 0
                    Behavior on opacity {
                        NumberAnimation { duration: 500; }
                    }

                    clip: true
                    Column {
                        id: mainmoreColumn
                        spacing: 4
                        // y: 4
                        Text {
                           x: 10
                           id: moretxt; z: 1
                           font.pointSize: 12 + screen.fontsize;
                           text: getMoreText();
                           color: "black"; wrapMode: Text.Wrap
                           width: (text.length > 0)?mainmore.width - 20:0
                           // anchors.left: image.right; anchors.right: blackRect.right; anchors.leftMargin: 6; anchors.rightMargin: 6
                           onLinkActivated: wrapper.handleLink(link)
                       }
                        Row {
                            x: 6
                            spacing: 3

                            NewButton {
                                // anchors.verticalCenter: parent.verticalCenter;
                                text: "Reply"
                                useimg: false
                                onClicked: clickedButton(0);
                                id: button0
                            }
                            NewButton {
                                useimg: false
                                text: "RT (comment)"
                                onClicked: clickedButton(1);
                                id: button1
                            }
                            NewButton {
                                useimg: false
                                text: "DM"
                                onClicked: clickedButton(6);
                                id: button6
                            }
                            NewButton {
                                useimg: false
                                text: "More..."
                                onClicked: clickedButton(2);
                                id: button2
                            }
                        }

                        Rectangle {
                            id: evenMoreButtons
                            height: childrenRect.height; width: wrapper.width-2;
                            color: "transparent"
                            clip: true
                            Column {
                                spacing: 3
                                Row {
                                    x: 6
                                    spacing: 3
                                    NewButton {
                                        useimg: false
                                        text: "Translate"
                                        onClicked: clickedButton(3);
                                        id: button3
                                    }
                                    NewButton {
                                        useimg: false
                                        text: "Follow"
                                        onClicked: clickedButton(4);
                                        id: button4
                                    }
                                    NewButton {
                                        useimg: false
                                        text: "Unfollow"
                                        onClicked: clickedButton(5);
                                        id: button5
                                    }
                                }
                            }
                        }
                        Rectangle {
                            height: 1; width: wrapper.width-2;
                            color: "#282828"
                        }
                    }
                }
             }
         }
         Component.onCompleted: setButtons();
     }

 }
