import QtQuick 1.0
// import "../js/OAuth.js" as OAuthLogic

Item { id: wrapper
    property variant model: getModel()
    property string phrase : ""
    property int amount : 15
    property int status: model.status
    property int timeout: 0
    property string mode: "home"
    property int notify: 0;
    property bool autoref: false;
    property bool apioverload: false;

    function getModel() {
        if (mode == 'home' || mode == 'list' || mode == 'mentions') return twitterModel;
        else if (mode == "search") return twittersearchModel;
        else if (mode == "user") return twitteruserModel;
        else if (mode == "dm") return twitterdmModel;
        else return rssModel;
    }
    function reload() {
        topbar.state = "loading";
        var url = '';
        var parameters = false;

        if (mode != "rss" && mode != "atom") {
            console.log("ok, loading. mode: " + mode);
            if (mode == "twittersearch") mode = "search";
            if(mode == 'home') {
                model = twitterModel
                console.log("this means we hit home...");
                url = 'http://api.twitter.com/1/statuses/home_timeline.xml';
                parameters = [["count",amount]];
                model = twitterModel
            } else if(mode == 'user') {
                url = 'http://api.twitter.com/1/statuses/user_timeline.xml';
                parameters = [["screen_name",phrase],["count",amount]];
                model = twitteruserModel
            } else if(mode == 'list') {
                var listvars = getListVars();
                url = 'http://api.twitter.com/1/' + listvars[0] + '/lists/' + listvars[1] + '/statuses.xml';
                parameters = [["per_page",amount]];
                model = twitterModel
            } else if(mode == 'mentions') {
                url = 'http://api.twitter.com/1/statuses/mentions.xml';
                parameters = [["count",amount], ["include_rts","true"]];
                model = twitterModel
            } else if (mode == 'dm') {
                url = 'http://api.twitter.com/1/direct_messages.xml'
                parameters = [["count",amount]];
                model = twitterdmModel
            } else if (mode == 'single') {
                url = 'http://api.twitter.com/1/statuses/show/' + phrase + '.xml';
                parameters = [];
                model = twittersingleModel
            } else if(mode == 'search') {
                // search
                console.log("found search with phrase " + escape(phrase));
                url = 'http://search.twitter.com/search.atom?q=' + escape(phrase) + '&rpp='+amount
                model = twittersearchModel
            }
            var xhr;
            if(oauth.authorized && mode != "search"){
                console.log("is authorized...");
                xhr = screen.js().createOAuthHeader("GET", url, undefined, {"token":oauth.token, "secret":oauth.secret}, parameters);
            } else {
                if (parameters) {

                    for (var i = 0; i < parameters.length; i++) {
                        url += (i == 0) ? "?" : "&";
                        url += parameters[i][0] + "=" + parameters[i][1];
                    }
                }
                console.log(url);
                xhr = new XMLHttpRequest;
                xhr.open("GET", url);
            }
            xhr.onreadystatechange = function() {
                if (xhr.readyState == XMLHttpRequest.DONE) {
                    // topbar.state = "";
                    // console.log(xhr.responseText);
                
                    if (xhr.status == 200) {
                        apioverload = false;
                        model.xml = xhr.responseText;
                    }
                    else if (xhr.status == 401 || xhr.status == 400 || xhr.status == 403 || xhr.status == 404
                             || xhr.status == 406 || xhr.status == 420 || xhr.status == 500 || xhr.status == 502 || xhr.status == 503) {
                        console.log("api overload");
                        apioverload = true
                    } else apioverload = false;

                    if (model.status == XmlListModel.Ready) {
                        topbar.state = "";
                        if (apioverload) topbar.state = "apioverload";
                    }
                    console.log("status: " + xhr.status);
                    if (mode == 'dm') {
                        // console.log(xhr.responseText);
                    }
                    if (timeout > 0) {
                        if (timeout < 10) timeout = 10;
                        console.log("restarting timer for " + phrase + "\nrefreshing in " + timeout + " seconds");
                        if (apioverload) autoRefresh.interval = autoRefresh.interval * 10 // delay refresh
                        autoRefresh.restart();
                    }

                }
            }
            xhr.send();
        } else {
            // rss
            model = rssModel;
            url = phrase;

            xhr = new XMLHttpRequest;
            xhr.open("GET", url);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == XMLHttpRequest.DONE) {
                    // topbar.state = "";
                    if (xhr.status == 200) rssModel.xml = xhr.responseText;
                    if (rssModel.status == XmlListModel.Ready) topbar.state = "";
                    if (timeout > 0) {
                        if (timeout < 10) timeout = 10;
                        console.log("RSS: restarting timer for " + phrase + "\nrefreshing in " + timeout + " seconds");
                        autoRefresh.restart();
                    }

                }
            }
            xhr.send();

        }
    }

    function getListVars() {
        var ret = phrase.split("/");
        if (ret.length == 1) return [screen.js().twitterusername,ret[0]];
        else if (ret.length != 2) return false;
        else return ret;
    }
    function reloadMore() {
        autoref = false;
        amount = amount + 15
        console.log("reloading with max " + amount + " items.");
        reload();

    }

    function resetReload() {
        amount = 15
        console.log("reset " + mode + " with 15 items");
        getModel();
        reload();

    }

    function manualReload() {
        autoref = false;
        resetReload();
    }

    function autoReloaded() {
        autoref = true;
        topbar.state = "loading";
        resetReload();
    }

    XmlListModel {
        property string modelType: mode
        property string searchText: phrase
        id: twitterModel

        query: "/statuses/status";
        XmlRole { name: "statusText"; query: "text/string()" }
        XmlRole { name: "timestamp"; query: "created_at/string()" }
        XmlRole { name: "source"; query: "source/string()" }
        XmlRole { name: "name"; query: "user/screen_name/string()" }
        XmlRole { name: "userImage"; query: "user/profile_image_url/string()" }
        XmlRole { name: "tweetId"; query: "id/string()" }
        XmlRole { name: "link"; query: "link[@rel = 'alternate']/@href/string()" }
        XmlRole { name: "inReplyToId"; query: "in_reply_to_status_id/string()" }
        XmlRole { name: "inReplyToUser"; query: "in_reply_to_user_id/string()" }
    }

    XmlListModel {
        property string modelType: mode
        property string searchText: phrase
        id: twitteruserModel

        query: "/statuses/status";
        XmlRole { name: "statusText"; query: "text/string()" }
        XmlRole { name: "timestamp"; query: "created_at/string()" }
        XmlRole { name: "source"; query: "source/string()" }
        XmlRole { name: "name"; query: "user/screen_name/string()" }
        XmlRole { name: "userImage"; query: "user/profile_image_url/string()" }
        XmlRole { name: "tweetId"; query: "id/string()" }
        XmlRole { name: "link"; query: "link[@rel = 'alternate']/@href/string()" }
        XmlRole { name: "inReplyToId"; query: "in_reply_to_status_id/string()" }
        XmlRole { name: "inReplyToUser"; query: "in_reply_to_user_id/string()" }

        XmlRole { name: "longname"; query: "user/name/string()" }
        XmlRole { name: "followers"; query: "user/followers_count/string()" }
        XmlRole { name: "friends"; query: "user/friends_count/string()" }
        XmlRole { name: "description"; query: "user/description/string()" }
        XmlRole { name: "tweets"; query: "user/statuses_count/string()" }
        XmlRole { name: "following"; query: "user/following/string()" }

    }

    XmlListModel {
        property string modelType: mode
        property string searchText: phrase
        id: twitterdmModel

        query: "/direct-messages/direct_message";
        XmlRole { name: "statusText"; query: "text/string()" }
        XmlRole { name: "timestamp"; query: "created_at/string()" }
        XmlRole { name: "source"; query: "source/string()" }
        XmlRole { name: "name"; query: "sender/screen_name/string()" }
        XmlRole { name: "userImage"; query: "sender/profile_image_url/string()" }
        XmlRole { name: "recipientname"; query: "recipient/screen_name/string()" }
        XmlRole { name: "tweetId"; query: "id/string()" }
    }

    XmlListModel {
        property string modelType: mode
        property string searchText: phrase
        id: twittersingleModel

        query: "/status";
        XmlRole { name: "statusText"; query: "text/string()" }
        XmlRole { name: "timestamp"; query: "created_at/string()" }
        XmlRole { name: "source"; query: "source/string()" }
        XmlRole { name: "name"; query: "user/screen_name/string()" }
        XmlRole { name: "userImage"; query: "user/profile_image_url/string()" }
        XmlRole { name: "tweetId"; query: "id/string()" }
        XmlRole { name: "link"; query: "link[@rel = 'alternate']/@href/string()" }
        XmlRole { name: "inReplyToId"; query: "in_reply_to_status_id/string()" }
        XmlRole { name: "inReplyToUser"; query: "in_reply_to_user_id/string()" }
    }

    XmlListModel {
        id: twittersearchModel
        property string modelType: mode
        property string searchText: phrase

        query: "/feed/entry";
        namespaceDeclarations: "declare default element namespace 'http://www.w3.org/2005/Atom'; " +
                                         "declare namespace twitter=\"http://api.twitter.com/\";";

        XmlRole { name: "statusText"; query: "title/string()" }
        XmlRole { name: "timestamp"; query: "published/string()" }
        XmlRole { name: "source"; query: "twitter:source/string()" }
        XmlRole { name: "name"; query: "author/name/string()" }
        XmlRole { name: "userImage"; query: "link[@rel = 'image']/@href/string()" }
        XmlRole { name: "tweetId"; query: "id/string()" }
        XmlRole { name: "link"; query: "link[@rel = 'alternate']/@href/string()" }

    }

    XmlListModel {
        property string modelType: mode
        property string searchText: phrase
        id: rssModel

        query: "/rss/channel/item"
        XmlRole { name: "title"; query: "title/string()" }
        XmlRole { name: "statusText"; query: "description/string()" }
        XmlRole { name: "timestamp"; query: "pubDate/string()" }
        XmlRole { name: "link"; query: "link/string()" }

    }


    Component.onCompleted: reload();
    Timer {
        id: autoRefresh
        interval: 1000 * timeout; running: false; repeat: false
        onTriggered: autoReloaded()
    }
}
