import QtQuick 1.0
BorderImage {
    signal clicked
    signal pressed
    signal released
    property alias bsource: buttonpic.source
    property alias text: buttontext.text
    property alias button: clickbutton
    property bool useimg: true
    property bool useimgsize: false
    property bool flat: false
    property bool checked: false
    property bool usecheckbox: false
    id: button
    source: (flat)?"images/buttonborderflat.png":"images/buttonborder.png"
    height: (useimgsize)?buttonpic.height + 15:45; width: (useimgsize || !useimg) ? content.width + 24 : 45
    border.left: 17; border.top: 17
    border.right: 17; border.bottom: 17
    horizontalTileMode: BorderImage.Repeat
    verticalTileMode: BorderImage.Repeat
    opacity: 0.8
    smooth: true
    Row {
        id: content
        anchors.centerIn: parent
        spacing: 3
        Image {
            id: checkbox
            anchors.verticalCenter: parent.verticalCenter
            opacity: (usecheckbox)?1:0
            source: (usecheckbox)?((checked)?"images/checkbox_checked.png":"images/checkbox_unchecked.png"):""
            smooth: true
        }
        Image {
            id: buttonpic
            anchors.verticalCenter: parent.verticalCenter
            opacity: (useimg)?1:0
            // source: "images/refresh.png"
            smooth: true
        }
        Text {
            id: buttontext
            font.pointSize: 12
            anchors.verticalCenter: parent.verticalCenter
            opacity: (useimg)?0:1
        }
    }
    MouseArea {
        anchors.fill: parent
        id: clickbutton
        onClicked: { button.clicked() }
        onPressed: { button.pressed() }
        onReleased: { button.released() }
    }
    states: [
        State {
            name: "pressed"
            when: clickbutton.pressed
            PropertyChanges {
                target: button
                source: "images/buttonborder2.png"
            }
            PropertyChanges {
                target: buttonpic
                opacity: (useimg)?0.8:0
            }
            PropertyChanges {
                target: buttontext
                opacity: (useimg)?0:0.8
            }
        }
    ]
}
