import QtQuick 1.0
import "js/tweedscripts.js" as Js

Item {
    function js() {
        return Js;
    }
    id: screen
    width: 800; height: 420
    Loading { id: loading }
    Storage { id: storage }
    TweetBox { id: tweetBox }
    ColumnBox { id: columnBox }
    // SettingsBox { id: settingsBox }
    AuthBox { id: authBox }
    OAuth {
        id: oauth
        onAuthenticationCompleted: {
            console.log("Auth completed!!");
            // Notty.notify("Tweedsuit","Auth completed!");
            storage.getColumns(["all"]);
/*            mainrowModel.append({ "search": "", "type": "home", "posit": storage.max + 1 })

            storage.storeColumn("home", "", storage.max + 1) */
        }
        onAuthenticationFailed: {
            console.log("auth failed signal received");
            storage.getColumns(["all"])
        }
    }

    function addNewTwitterColumn(str, type, timeout, notify) {
        if (!timeout) timeout = 0;
        console.log("adding " + type + " column with text " + str);
        mainrowModel.append({ "search": str, "type": type, "posit": storage.max + 1, "timeout": timeout, "notify": notify })
        storage.storeColumn(type, str, storage.max + 1, timeout, notify);
    }

    function removeColumn(indx, poss) {
        console.log("removing: indx is " + indx + " and poss is " + poss)
        storage.removeRow(poss)
        mainrowModel.remove(indx)
    }

    function initialAuth() {
        storage.checkDb();
        var userdata = storage.getAuth();
        console.log("Recieved user " + userdata[0]);
        if (userdata) {
            authBox.doLogin(userdata[0], userdata[1]);
        } else {
            console.log("no login found");
            authBox.doLogin("", "");
        }
    }

    Rectangle {
        x: 0; y: 0
        // main background color
        // color: "black"
        gradient: bg
        width: parent.width
        height: parent.height
        RowModel { id: mainrowModel }
        SearchColumn { id: mainrowDelegate }
        // Twitter.RowDelegate { id: mainrowDelegate }
        Rectangle {
            x: 50; y: 0; z: 1
            width: parent.width - 50
            height: parent.height
            clip: false
            color: "transparent"
            ListView {
                id: mainrow
                cacheBuffer: 5000
                anchors.fill: parent
                orientation: ListView.Horizontal
                flickableDirection: Flickable.HorizontalFlick
                model: mainrowModel
                delegate: mainrowDelegate
                snapMode: ListView.SnapToItem
                boundsBehavior: Flickable.DragOverBounds 
            }
        }

        Gradient {
            id: bg
            GradientStop { position: 0.3; color: "#ccc" }
            GradientStop { position: 1.0; color: "#666" }
        }
        /* Image {
            anchors.fill: parent
            source: "images/tweed_bg.png"
            fillMode: Image.Tile
            opacity: 0.1
        } */
    }
    Component.onCompleted: initialAuth();
}
