import QtQuick 1.0

Rectangle {
    property string imgSource: ""
    property int maxw: screen.width - 80
    property int maxh: screen.height - 80
    id: imgBox
    z: 5
    y: Math.floor((screen.height / 2) - (imgBox.height / 2))
    anchors.horizontalCenter: screen.horizontalCenter;
    width: 240
    height: 135
    // anchors.centerIn: parent
    radius: 5
    smooth: true
    border.width: 1
    border.color: "grey"
    gradient: Gradient {
        GradientStop { position: 0.0; color: "#bbb" }
        GradientStop { position: 1.0; color: "#eee" }
    }
    clip: true;
    Behavior on x { NumberAnimation { duration: 300 } }
    Behavior on y { NumberAnimation { duration: 300 } }
    Image {
        id: viewimage
        width: (sourceSize.width <= 64) ? 128 : ((sourceSize.width >= maxw) ? maxw : sourceSize.width)
        height: (sourceSize.height <= 64) ? 128 : ((sourceSize.height >= maxh) ? maxh : sourceSize.height)
        anchors.centerIn: parent
        fillMode: Image.PreserveAspectFit
        smooth: true
        source: imgSource
        opacity: 0
        // cache: false
        Behavior on opacity { NumberAnimation { duration: 500 } }
        onStatusChanged: {
            if (status == Image.Ready)
            imgBox.state="show"
        }
    }
    AnimatedImage {
        id: loadingpic
        anchors.centerIn: parent
        source: "images/loading_small.gif"
    }
    Text {

    }

    MouseArea {
        anchors.fill: parent
        onClicked: imgBox.destroy();
    }

    states: [
        State {
            name: "show"
            PropertyChanges { target: viewimage; opacity: 1 }
            PropertyChanges { target: loadingpic; opacity: 0; source: "" }
            // PropertyChanges { target: imgBox; width: (viewimage.width >= 640) ? 660 : viewimage.width + 20 }
            // PropertyChanges { target: imgBox; height: (viewimage.height >= 360) ? 380 : viewimage.height + 20 }
            PropertyChanges { target: imgBox; width: viewimage.width + 20 }
            PropertyChanges { target: imgBox; height: viewimage.height + 20 }
        }
    ]

}
