import QtQuick 1.0
Rectangle {
    property alias headline: hd.text
    property alias infotext: info.text
    property alias bgimage: bgimage.source
    property alias state: topbar.state
    property string type: "search"
    signal closeClicked
    signal refreshClicked
    signal moverightClicked
    signal moveleftClicked
    id: topbar
    width: 373
    height: 45
    color: "black"
    clip: true

    Text {
        anchors.verticalCenter: top.verticalCenter
        id: hd
        font.weight: Font.Light
        font.pointSize: 15
        color: "black"
        text: ""
        z: 3
        x: 10
        width: 280
        clip: true
    }


    Rectangle {
        x: 0; y: 45
        width:  373
        height: 55
        opacity: 0
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#bbb" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        id: refreshing
        AnimatedImage {
            anchors.centerIn: parent
            source: "images/loading_small.gif"
        }

        Behavior on opacity {
            NumberAnimation { duration: 300 }
        }
    }
    Behavior on height {
        NumberAnimation { duration: 200; }
    }



    Image { // moving background
        z: 1
        id: bgimage
        // source: screen.js().getBgSource(type);
        x: -140
        y: -110
        smooth: true
        Behavior on x {
            NumberAnimation { duration: 10000; }
        }
        Behavior on y {
            NumberAnimation { duration: 10000; }
        }
        states: [
            State {
                name: "out"
                when: topbar.height > 45
                PropertyChanges {
                    target: bgimage
                    x: -20
                    y: -50
                }
            },
            State {
                name: "in"
                when: topbar.height <= 45
                PropertyChanges {
                    target: bgimage
                    x: -140
                    y: -110
                }
            }
        ]
    }

    Rectangle { // top bar.
        id: top
        x: 0; y: 0
        width: 373;
        height: 45;
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#666" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        Behavior on opacity {
            NumberAnimation { duration: 500; }
        }
        //color: "#eee"
        MouseArea {
            anchors.fill:  parent
            onClicked: {
                // topbar.moverightClicked()
                if (topbar.height > 45) {
                    topbar.state = ""
                    bgimage.state = ""
                } else {
                    topbar.state = "open"
                    bgimage.state = "out"
                }
            }
            onPressAndHold: {
                topbar.state = "edit"
            }
        }
    }


    NewButton {
        x: 285; y: 0
        z: 3
        id: refresh
        useimg: true
        bsource: "images/refresh.png"
        onClicked: { topbar.refreshClicked() }
    }

    NewButton {
        x: 325; y: 0
        z: 3
        id: close
        useimg: true
        bsource: "images/close.png"
        onClicked: { topbar.closeClicked() }
    }

    Rectangle { // dropdown gradient
        id: infocontainer
        z: 0
        x: 0
        y: 45
        width: 373
        height: topbar.height - 45
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#bbb" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        Behavior on opacity {
            NumberAnimation { duration: 500; }
        }
        opacity: 0
    }
    Text {
        id: info
        z: 3
        x: 10
        y: 50
        font.pointSize: 10
        font.weight: Font.Light
        color: "black"
        wrapMode: Text.WordWrap
        textFormat: Text.RichText
        onLinkActivated: Qt.openUrlExternally(link)
        opacity: infocontainer.opacity
        width: 355
    }

    Rectangle {
        id: editbox
        z: 5
        x: 0
        y: 45
        width: 373
        height: topbar.height - 45
        opacity: 0
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#bbb" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        Behavior on opacity {
            NumberAnimation { duration: 500; }
        }
        NewButton {
            anchors.left: parent.left
            anchors.leftMargin: 5
            anchors.verticalCenter: parent.verticalCenter
            id: left
            useimg: false
            text: "<<"
            onClicked: { topbar.moveleftClicked() }
        }
        NewButton {
            anchors.right: parent.right
            anchors.rightMargin: 5
            anchors.verticalCenter: parent.verticalCenter
            id: right
            useimg: false
            text: ">>"
            onClicked: { topbar.moverightClicked() }
        }
    }

    states: [
        State {
            name: "open"

            PropertyChanges {
                target: topbar
                height: (100 > info.height + 55) ? 100 : info.height + 55
            }
            PropertyChanges {
                target: infocontainer
                opacity: 1
            }
        },
        State {
            name: "loading"
            PropertyChanges {
                target: topbar
                height: 100
            }
            PropertyChanges {
                target: refreshing
                opacity: 1
            }
            PropertyChanges {
                target:  infocontainer
                opacity: 0
            }
        },
        State {
            name: "edit"
            PropertyChanges {
                target: topbar
                height: 100
            }
            PropertyChanges {
                target: editbox
                opacity: 1
            }
        }
    ]
}
