import QtQuick 1.0



Rectangle {
    id: theButton
    signal clicked
    property string text
    property int fontSize: 12
    width: textarea.width + 15
    height: textarea.height + 20
    border.width: 1
    border.color: "black"
    smooth: true
    radius: 5
    gradient: unpressed
    Text {
        id: textarea
        text: theButton.text
        anchors.centerIn: parent
        font.pointSize: fontSize
    }

    MouseArea {
        id: mouseRegion
        anchors.fill: theButton
        onClicked: {
            theButton.clicked();
        }
    }
    Gradient {
        id: unpressed
        GradientStop { position: 0.0; color: "darkgrey" }
        GradientStop { position: 1.0; color: "grey" }
    }

    Gradient {
        id: onpressed
        GradientStop { position: 0.0; color: "grey" }
        GradientStop { position: 1.0; color: "darkgrey" }
    }

    states: [
        State {
            name: "Pressed"
            when: mouseRegion.pressed == true
            PropertyChanges {
                target: theButton; gradient: onpressed
            }
        }
    ]
}
