import Qt 4.7

Item {
    property string inReplyTo: "";
    property alias tweetText: postInput.text;
    id: tweetBox
    x: -601
    y: 15
    z: 5
    Behavior on x {
        SpringAnimation { mass: 0.8; spring: 8; damping: 0.3 }
    }
    Rectangle {
        id: inputArea
        width: 600
        height: bottomSpacer.y + bottomSpacer.height
        //color: "grey"
        smooth: true
        border.width: 1
        border.color: "black"
        radius: 5
        gradient: boxgrad
        Gradient {
            id: boxgrad
            GradientStop { position: 0.0; color: "darkgrey" }
            GradientStop { position: 1.0; color: "grey" }
        }
        Image {
            anchors.fill: parent
            source: "images/tweed_bg.png"
            fillMode: Image.Tile
            opacity: 0.5
        }
        Text {
            id: label
            text: (140 - postInput.text.length) + " characters left"
            font.pointSize: 12
            x: 10
            y: 5
        }

        Rectangle {
            id: postInputContainer
            width: 570
            height: 90
            color: "white"
            border.width: 1
            x: 15
            y: label.y + label.height + 3
            TextEdit {
                x: 3
                y: 2
                selectByMouse: true
                Keys.onReturnPressed: tweetBox.sendPost();
                Keys.onEnterPressed: tweetBox.sendPost();
                font.pointSize: 15
                id: postInput
                width: parent.width - 6
                height: parent.height - 4
                wrapMode: TextEdit.Wrap;
            }
        }
        Button {
            x: parent.width - 5 - width
            y: postInputContainer.y + postInputContainer.height + 5
            text: "Send"
            onClicked: tweetBox.sendPost()
            id: postButton
        }

        Button {
            x: postButton.x - 5 - width
            y: postInputContainer.y + postInputContainer.height + 5
            text: "met.al"
            onClicked: tweetBox.shortenUrls("met.al");
            id: metalButton
        }

        Button {
            x: metalButton.x - 5 - width
            y: postInputContainer.y + postInputContainer.height + 5
            text: "is.gd"
            onClicked: tweetBox.shortenUrls("is.gd");
            id: isgdButton
        }

        Rectangle {
            id: bottomSpacer;
            y: postButton.y + postButton.height
            height: 5
            color: "transparent"
        }
    }
    Rectangle {
        id: dragArea
        width: 60
        height: 50
        //color: "grey"
        gradient: boxgrad
        smooth: true

        border.width: 1
        radius: 10
        x: inputArea.x + inputArea.width - 5
        y: inputArea.y + 10
        Image {
            source: 'images/twitterbird_40x40.png'
            anchors.centerIn: parent
        }
    }
    MouseArea {
        id: hook
        anchors.fill: dragArea
        drag.axis: Drag.XAxis
        drag.target: tweetBox
        onClicked: {
            if (tweetBox.state != "open") {
                tweetBox.state = "open"
                columnBox.state = "closed"
                console.log("Opened");
            } else {
                tweetBox.state = "closed";
                console.log("Closed");
            }
        }
            
        onReleased: {
            if (drag.active == true) {
                console.log("dragging tweetBox")
                console.log("state = " + tweetBox.state)
                console.log("x = " + tweetBox.x)
                if (tweetBox.state != "closed") {
                    if (tweetBox.x < 0) {
                        tweetBox.state = "closed"
                    } else {
                        tweetBox.state = "move"
                        tweetBox.state = "open"
                        columnBox.state = "closed"

                    }
                } else {
                    if (tweetBox.x > -541) {
                        tweetBox.state = "open"
                        columnBox.state = "closed"
                    } else {
                        tweetBox.state = "move"
                        tweetBox.state = "closed"
                    }
                }
            }                          
        }
    }

    states: [
        State {
            name: "closed"
            PropertyChanges { target: tweetBox; x: -601 }
        },

        State {
            name: "open"
            PropertyChanges { target: tweetBox; x: 60 }
         },
        State {
            name: "move"
        }
    ]

    function sendPost() {
        console.log ("sendPost clicked with content \"" + postInput.text + "\"");
        tweetBox.state = "closed"
        screen.js().sendTweet(postInput.text, [["in_reply_to_status_id",inReplyTo]]);
        postInput.text = ""
        inReplyTo = "";
        return true
    }

    function shortenUrls(shortener) {
        postInput.text = screen.js().shortenUrl(postInput.text, shortener);
    }
}
