import Qt 4.7

Item {
    id: columnBox
    x: -601
    y: 70
    z: 5
    // property string state

    Behavior on x {
        SpringAnimation { mass: 0.8; spring: 8; damping: 0.3 }
    }
    Rectangle {
        id: inputArea
        width: 600
        height: timeoutInputContainer.height + timeoutInputContainer.y + 5
        //color: "grey"
        smooth: true
        z: 1
        border.width: 1
        border.color: "black"
        radius: 5
        gradient: boxgrad
        Gradient {
            id: boxgrad
            GradientStop { position: 0.0; color: "darkgrey" }
            GradientStop { position: 1.0; color: "grey" }
        }
        Image {
            anchors.fill: parent
            source: "images/tweed_bg.png"
            fillMode: Image.Tile
            opacity: 0.5
        }
        Text {
            id: label
            text: "Search phrase or rss url"
            font.pointSize: 12
            x: 10
            y: 5
        }

        Rectangle {
            id: searchInputContainer
            width: 570
            height: 60
            color: "white"
            border.width: 1
            x: 15
            y: label.y + label.height + 3
            TextEdit {
                x: 3
                y: 2
                Keys.onReturnPressed: inputArea.addColumn("search");
                Keys.onEnterPressed: inputArea.addColumn("search");
                font.pointSize: 15
                id: searchInput
                width: parent.width - 6
                height: parent.height - 4
                wrapMode: TextEdit.Wrap
            }
        }
        Text {
            id: label2
            text: "Refresh rate"
            font.pointSize: 12
            x: 10
            y: searchInputContainer.y +  searchInputContainer.height + 5

        }
        Button {
            x: label2.x + label2.width + 5
            y: Math.round(((label2.y + timeoutInputContainer.height + timeoutInputContainer.y) / 2) - (height/2))
            property int notify: 0
            text: "Notify"
            id: notifyToggle
            onClicked: {
                if (notify > 0) {
                    notify = 0;
                    label3.text = "<b>[No ]</b>";
                } else {
                    notify = 1;
                    label3.text = "<b>[Yes ]</b>";
                }
            }
        }
        Text {
            x: notifyToggle.x + notifyToggle.width + 5
            y: Math.round(((label2.y + timeoutInputContainer.height + timeoutInputContainer.y) / 2) - (height/2))
            id: label3
            text: "<b>[No ]</b>"
            font.pointSize: 12
        }
        Rectangle {
            id: timeoutInputContainer
            width: 50; height: 30;
            color: "white"
            border.width: 1
            x: 15; y: label2.y + label.height + 3
            TextInput {
                x: 3
                y: 2
                font.pointSize: 15
                id: timeoutInput
                text: "0"
                width: parent.width - 6
                height: parent.height - 4
            }
        }
        Row {
            spacing: 5
            x: parent.width - 5 - width
            y: Math.round(((label2.y + timeoutInputContainer.height + timeoutInputContainer.y) / 2) - (height/2))
            Button {
                text: "more"
                onClicked: {
                    if (moreButtonsArea.state == "")
                        moreButtonsArea.state = "show";
                    else
                        moreButtonsArea.state = "";

                }
                id: moreButton
            }


            Button {
                // x: dmButton.x - 5 - width
                // y: Math.round(((label2.y + timeoutInputContainer.height + timeoutInputContainer.y) / 2) - (height/2))
                text: "Add RSS"
                onClicked: inputArea.addColumn("rss")
                id: rssButton
            }

            Button {
                text: "Add User"
                onClicked: inputArea.addColumn("user")
                id: userButton
            }

            Button {
                // x: parent.width - 5 - width
                text: "Add Search"
                onClicked: inputArea.addColumn("search")
                id: searchButton
                fontSize: 12;
            }

        }
/*
        Button {
            x: mentionsButton.x - 5 - width
            y: Math.round(((label2.y + timeoutInputContainer.height + timeoutInputContainer.y) / 2) - (height/2))
            text: "Add home"
            onClicked: inputArea.addColumn("home")
            id: homeButton
        }

        Button {
            x: searchButton.x - 5 - width
            y: Math.round(((label2.y + timeoutInputContainer.height + timeoutInputContainer.y) / 2) - (height/2))
            text: "Add mentions"
            onClicked: inputArea.addColumn("mentions")
            id: mentionsButton
        }

        Button {
            x: homeButton.x - 5 - width
            y: Math.round(((label2.y + timeoutInputContainer.height + timeoutInputContainer.y) / 2) - (height/2))
            text: "Add DM"
            onClicked: inputArea.addColumn("dm")
            id: dmButton
        }
*/

        Rectangle {
            y: searchButton.y + searchButton.height
            height: 5
            color: "transparent"
        }

        function addColumn (type) {
            console.log ("add column clicked")
            screen.addNewTwitterColumn(searchInput.text, type, parseInt(timeoutInput.text), notifyToggle.notify);

            // mainrowModel.append({ search: searchInput.text })
            columnBox.state = "closed"
            searchInput.text = ""
            return true
            // mainrowModel.reload()
        }
    }
    Rectangle {
        property bool shown: false
        id: moreButtonsArea
        x: 10; y: 5; z: 0
        width: inputArea.width - 20;
        height: inputArea.height - 20;
        opacity: ((inputArea.height - (moreButtonsArea.height - moreButtonsRow.height - 10) + y - 10) / (inputArea.height - (moreButtonsArea.height - moreButtonsRow.height - 10) - 5)) - 1
        color: "lightgrey"
        border.width: 1
        border.color: "black"
        states: [
            State {
                name: "show"
                PropertyChanges {
                    target: moreButtonsArea
                    y: inputArea.height - (moreButtonsArea.height - moreButtonsRow.height - 10)
                }
            }
        ]
        transitions: [
            Transition {
                NumberAnimation { target: moreButtonsArea; property: "y"; duration: 100 }
            }
        ]


        Grid {
            id: moreButtonsRow
            spacing: 5
            columns: 7
            x: moreButtonsArea.width - 5 - width
            y: moreButtonsArea.height - 5 - height
            Button {
                text: "Add home"
                onClicked: inputArea.addColumn("home")
                id: homeButton
            }

            Button {
                text: "Add Mentions"
                onClicked: inputArea.addColumn("mentions")
                id: mentionsButton
            }

            Button {
                text: "Add DM"
                onClicked: inputArea.addColumn("dm")
                id: dmButton
            }
            Button {
                text: "Add List"
                onClicked: inputArea.addColumn("list")
                id: listButton
            }
        }

    }
    Rectangle {
        id: dragArea
        width: 60
        height: 50
        z: 2
        //color: "grey"
        gradient: boxgrad
        smooth: true
        border.width: 1
        border.color: "black"
        radius: 10
        x: inputArea.x + inputArea.width - 5
        y: inputArea.y + 10
        Text {
            color: "lightgrey"; text: "<b>+</b>"; font.pixelSize: 30;
            anchors.centerIn: parent
        }
    }
    MouseArea {
        id: hook
        anchors.fill: dragArea
        drag.axis: Drag.XAxis
        drag.target: columnBox
        onClicked: {
            if (columnBox.state != "open") {
                columnBox.state = "open"
                tweetBox.state = "closed"
                console.log("Opened");
                console.log(label2.y + "|" + timeoutInputContainer.height + "|" + timeoutInputContainer.y + "|" + height + "|" + searchButton.y)

            } else {
                columnBox.state = "closed";
                console.log("Closed");
            }
        }

        onReleased: {
            if (drag.active == true) {
                console.log("dragging")
                if (columnBox.state != "closed") {
                    if (columnBox.x < 0) {
                        columnBox.state = "closed"
                    } else {
                        columnBox.state = "move"
                        columnBox.state = "open"
                        tweetBox.state = "closed"
                    }
                } else {
                    if (columnBox.x > -541) {
                        columnBox.state = "open"
                        tweetBox.state = "closed"
                    } else {
                        columnBox.state = "move"
                        columnBox.state = "closed"
                    }
                }
            }
        }
    }

    states: [
        State {
            name: "closed"
            PropertyChanges { target: columnBox; x: -601 }
        },

        State {
            name: "open"
            PropertyChanges { target: columnBox; x: 60 }
         },
        State {
            name: "move"
        }
    ]
}
