/*
 * TurnOver - try to turn over all the chess pieces
 * Copyright (C) 2010 Xizhi Zhu
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "mainwindow.h"

#include <QtGui/QGraphicsView>
#include <QtGui/QHBoxLayout>
#include <QtGui/QMenuBar>
#include <QtGui/QMessageBox>


MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), column(5), row(5), settingDialog(NULL)
{
    setupUi();
    setupAction();

    initGame();
}

MainWindow::~MainWindow()
{
    // do nothing
}

void MainWindow::changeSetting(int column, int row)
{
    this->column = column;
    this->row = row;

    initGame();
}

void MainWindow::initGame()
{
    scene->initBoard(column, row);
}

void MainWindow::showAbout()
{
    QMessageBox::about(this, "About",
                       "TurnOver - try to turn over all the chess pieces\n"
                       "by Xizhi Zhu <xizhi.zhu@gmail.com>\n"
                       "under GPL version 3");
}

void MainWindow::showSetting()
{
    if (settingDialog == NULL) {
        settingDialog = new SettingDialog(this);
        connect(settingDialog, SIGNAL(settingChanged(int,int)), SLOT(changeSetting(int,int)));
    }

    settingDialog->show(column, row);
}

void MainWindow::showWinner(int clicks)
{
    QMessageBox::information(this, "Congratulations!",
                             QString("You won the game with only %1 clicks!").arg(clicks));
    initGame();
}

void MainWindow::setupAction()
{
    restartAction = menuBar()->addAction("Restart");
    connect(restartAction, SIGNAL(triggered()), SLOT(initGame()));

    settingAction = menuBar()->addAction("Setting");
    connect(settingAction, SIGNAL(triggered()), SLOT(showSetting()));

    aboutAction = menuBar()->addAction("About");
    connect(aboutAction, SIGNAL(triggered()), SLOT(showAbout()));
}

void MainWindow::setupUi()
{
    setWindowTitle("TurnOver");

    scene = new Scene(this);
    connect(scene, SIGNAL(gameFinished(int)), SLOT(showWinner(int)));

    QGraphicsView *view = new QGraphicsView(scene);
    setCentralWidget(view);
}
