#!/usr/bin/python

import urllib2 as urllib
from os import path

#URL = 'http://www.tfl.gov.uk/tfl/livetravelnews/realtime/by-date.aspx?offset=weekend'
URL = 'http://www.tfl.gov.uk/tfl/livetravelnews/realtime/tube/default.html'

OUTFILE = 'Closures.txt'

GOOD_SERVICE = ['Good service']
PART_CLOSURE = ['Part closure', 'Part suspended']
DELAYS = ['Severe delays']
PLANNED_CLOSURE = ['Planned closure']
LINE_ID = '<dt class="'
STATION_ID = '<h3>'
STATION_END_ID = '<dt>Station maintenance</dt>'
TUBE_LINES = 'Tube lines'
TUBE_STATIONS = 'Closed stations'

LINES = ['Bakerloo', 'Central', 'Circle', 'District', 'Hammersmith & City', 'Jubilee', 'Metropolitan', 'Northern', 'Piccadilly', 'Victoria', 'Waterloo & City']

LINE_REPLACEMENTS = [['H\'smith', 'Hammersmith']]
STATION_REPLACEMENTS = [['Bank','Bank & Monument'], ['Monument','Bank & Monument'], ['Station', '']]
INFO_REPLACEMENTS = [['</p><P>', ''], [' between ', ' from '], [' and ', ' to ']]

def parse_routeinfo(msg):
	routes = []
	origin = ""
	destination = ""
	for repl in INFO_REPLACEMENTS:
		msg = msg.replace(repl[0], repl[1])
	msg = msg.split('Service')[0] + ' .'
	bus = msg.find(' bus ') > -1
	while msg != "":
		keyword = 'from ';
		s = msg[msg.find(keyword) + len(keyword):].strip()
		keyword = 'to ';
		origin = s[:s.find(keyword)].strip()
		s = s[s.find(keyword) + len(keyword):].strip()
		s = s.split()
		for i in range(len(s)):
			if not s[i][0].isupper():
				destination = ' '.join(s[0:i])
				msg = ' '.join(s[i:])
				break
		if origin == "" or destination == "":
			msg = ""
		else:
			origin = origin.split('.')[0]
			destination = destination.split('.')[0]
			for repl in STATION_REPLACEMENTS:
				origin = origin.replace(repl[0], repl[1])
				destination = destination.replace(repl[0], repl[1])
			if not bus:
				routes.append("%s,%s" % (origin, destination))
			else:
				routes.append("%s,%s,bus" % (origin, destination))
	return routes

def get_info(msg):
	s = msg.split('>')
	if len(s) >= 2:
		s = s[1].split('<')
		if len(s) >= 2:
			s = s[0].replace('&amp;', '&')
			for repl in LINE_REPLACEMENTS:
				s = s.replace(repl[0], repl[1])
			return s.strip()
	return ""

def parse_affected(routename, portions):
	affected = []
	if routename != "":
		for portion in portions:
			affected.append("%s,%s" % (routename, portion))
	return affected

def get(fname=OUTFILE):
	mode = ""
	affected = ""
	planned_closures = ""
	part_closures = ""
	delays = ""
	station_closures = ""
	interchange_closures = ""
	print "Parsing data..."

	try:
		print "Fetching data from TfL website..."
		f = urllib.urlopen(URL, None)
		lines = f.readlines()
		f.close()
		for i in range(len(lines)):
			s = get_info(lines[i])
			if s != "":
				if s == TUBE_LINES:
					mode = "T"
					print "  (1/2) Tube lines."
				elif s == TUBE_STATIONS:
					mode = "S"
					print "  (2/2) Tube stations."
				else:
					if mode == "T":
						line = lines[i].strip()
						if line != "":
							if line[0:len(LINE_ID)] == LINE_ID:
								affected = get_info(line)
							else:
								if s in PART_CLOSURE:
									i += 2
									part_closures += ';'.join(parse_affected(affected, parse_routeinfo(lines[i]))) + ';'
								if s in PLANNED_CLOSURE:
									planned_closures += affected + ';'
								if s in DELAYS:
									delays += affected + ';'
					elif mode == "S":
						line = lines[i].strip()
						if line == STATION_END_ID:
							mode = ""
						if line != "":
							if line[0:len(STATION_ID)] == STATION_ID:
								for repl in STATION_REPLACEMENTS:
									affected = get_info(line).replace(repl[0], repl[1]).strip()
								i += 2
								line = lines[i]
								interchange = False
								for tube_line in LINES:
									if line.find(tube_line) != -1:
										interchange = True
										interchange_closures += "%s,%s,*;" % (affected, tube_line)
								if not interchange:
									station_closures += affected + ";"
	except IOError:
		print "Could not fetch data."
	if part_closures == "":
		part_closures = ";"
	if station_closures == "":
		station_closures = ";"
	if interchange_closures == "":
		interchange_closures = ";"
	if delays == "":
		delays = ";"

	if not path.exists(fname):
		try:
			print "Writing file..."
			f = open(fname, 'w')
			f.write(planned_closures + part_closures + '# Line closures\n')
			f.write(delays + '# Delays\n')
			f.write(station_closures + '# Station closures\n')
			f.write(interchange_closures + '# Interchange closures')
			f.close()
			print "Done."
		except IOError:
			print "Could not fetch data."

if __name__ == "__main__":
	get()
