/* Copyright (C) 2006 - 2010 Jan Kundrát <jkt@gentoo.org>
   Copyright (C) 2010 Benson Tsai <btsai@vrwarp.com>

   This file is part of the Trojita Qt IMAP e-mail client,
   http://trojita.flaska.net/

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or the version 3 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _BASE_WINDOW_H_
#define _BASE_WINDOW_H_

#include <QMainWindow>
#include <QMaemo5InformationBox>
#include <QDebug>

#include "Imap/ConnectionState.h"

class QAuthenticator;

namespace Imap {
namespace Mailbox {

class Model;

}
}

namespace Gui {

class BaseWindow: public QMainWindow {
    Q_OBJECT
    typedef QList<QPair<QString,QString> > _recipientsType;
public:
    BaseWindow(Imap::Mailbox::Model* model, QWidget* parent=0);
    void invokeComposeDialog( const QString& subject = QString(),
                              const QString& body = QString(),
                              const _recipientsType& recipients = _recipientsType() );

public slots:
    void alertReceived( const QString& message );
    void networkPolicyOffline();
    void networkPolicyExpensive();
    void networkPolicyOnline();
    void slotShowSettings();
    void connectionError( const QString& message );
    void authenticationRequested( QAuthenticator* auth );
    void slotComposeMail();
    void showConnectionStatus( QObject* parser, Imap::ConnectionState state );
    void updateBusyParsers( bool busy );
    void slotShowAboutTrojita();

protected:
    // Protected constructor/init for windows that create the models
    BaseWindow(QWidget* parent=0);
    void init();

    Imap::Mailbox::Model* model;

    QMaemo5InformationBox status;

    QAction* netOffline;
    QAction* netExpensive;
    QAction* netOnline;
    QAction* configSettings;
    QAction* composeMail;
    QAction* aboutTrojita;

private:
    void createActions();
    void setupModels();
    void connectModelActions();

    BaseWindow(const BaseWindow&); // don't implement
    BaseWindow& operator=(const BaseWindow&); // don't implement
};

}

#endif
