
/*
 * This file is part of Maemo 5 Office UI for KOffice
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "CurlRequest.h"


/*
 * Set USE_CURL_VERBOSE_MODE to 1 to get CURLlibrary
 * to display a lot of verbose information about its operations
 */
#define USE_CURL_VERBOSE_MODE 0


#if 0
/* we want to use our own read function */
curl_easy_setopt(curl, CURLOPT_READFUNCTION, read_callback);

static size_t read_callback(void *ptr, size_t size, size_t nmemb, void *stream)
{
  size_t retcode;

  /* in real-world cases, this would probably get this data differently
     as this fread() stuff is exactly what the library already would do
     by default internally */
  retcode = fread(ptr, size, nmemb, stream);

  fprintf(stderr, "*** We read %d bytes from file\n", retcode);

  return retcode;
}
#endif


#if USE_CURL_VERBOSE_MODE
static size_t write_callback(void *ptr, size_t size, size_t nmemb, FILE *stream) {
        size_t written;
        written = fwrite(ptr, size, nmemb, stream);
        printf("\t %u\n", written);
        return written;
}
#endif

CURLcode google_translate_file(const char* in_file_name, const char* out_file_name,
                                                                const char* sl, const char *tl, const char *proxy) {
        FILE *fp = NULL;
        char *url = (char *)"http://translate.googleusercontent.com/translate_f";
        CURL *curl = NULL;
        CURLcode curl_error = CURLE_OK;
        struct curl_slist *header_tags = NULL;
        struct curl_httppost *post_chunks = NULL;
        struct curl_httppost *lastptr = NULL;
        long http_error_code;


        curl = curl_easy_init();
        if (NULL == curl) {
                curl_error = CURLE_FAILED_INIT;
                return curl_error;
        }

        fp = fopen(out_file_name, "wb");
        if (NULL == fp) {
                curl_error = CURLE_WRITE_ERROR;
                curl_easy_cleanup(curl);
                return curl_error;
        }

        /* Fill in the file upload field */
        curl_formadd(&post_chunks,
                &lastptr,
                CURLFORM_COPYNAME, "file",
                CURLFORM_FILE, in_file_name,
                CURLFORM_END);

        /* Fill in the incoding */
        curl_formadd(&post_chunks,
                &lastptr,
                CURLFORM_COPYNAME, "ie",
                CURLFORM_COPYCONTENTS, "eotf",
                CURLFORM_END);


        /* Fill in the src lang */
        curl_formadd(&post_chunks,
                &lastptr,
                CURLFORM_COPYNAME, "sl",
                CURLFORM_COPYCONTENTS, sl,
                CURLFORM_END);


        /* Fill in the src lang */
        curl_formadd(&post_chunks,
                &lastptr,
                CURLFORM_COPYNAME, "tl",
                CURLFORM_COPYCONTENTS, tl,
                CURLFORM_END);

        curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_ENCODING, "gzip,deflate");
        curl_easy_setopt(curl, CURLOPT_HTTPPOST, post_chunks);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, fp);
#if USE_CURL_VERBOSE_MODE
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_callback);
#endif
        if (NULL != proxy) {
                curl_easy_setopt(curl, CURLOPT_PROXY, proxy);
        }
#if USE_CURL_VERBOSE_MODE
        curl_easy_setopt(curl, CURLOPT_VERBOSE, 1);
#endif

        /* Fill in HTTP header */
#if 0
        header_tags = curl_slist_append(header_tags, "User-Agent: Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9.1.7) Gecko/20100106 Ubuntu/9.10 (karmic) Firefox/3.5.7");
        header_tags = curl_slist_append(header_tags, "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        header_tags = curl_slist_append(header_tags, "Keep-Alive: 300");
        header_tags = curl_slist_append(header_tags, "Proxy-Connection: keep-alive");
#endif
        /* Using POST with HTTP 1.1 implies the use of a "Expect: 100-continue" header. Disable it. */
        header_tags = curl_slist_append(header_tags, "Expect:");
        /* Fill in Referer tag */
        header_tags = curl_slist_append(header_tags, "Referer: http://translate.google.com/");
        curl_easy_setopt(curl, CURLOPT_HTTPHEADER, header_tags);

        curl_error = curl_easy_perform(curl);
        if (curl_error)
        {
                goto cleanup;
        }

        /* check if HTTP response error code is equal 200 */
        curl_error = curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &http_error_code);
#if USE_CURL_VERBOSE_MODE
        printf("CURLINFO_RESPONSE_CODE = %ld\n", http_error_code);
#endif
        if (curl_error)
        {
                goto cleanup;
        } else if (http_error_code != 200) {
                curl_error = CURLE_COULDNT_CONNECT; // just set generic error, otherwise need to parse all HTTP response error codes
                goto cleanup;
        }

#if 0
/*
        Commented the code below because it does not really work
*/
/*
From description of curl_easy_getinfo() on http://curl.haxx.se/libcurl/c/curl_easy_getinfo.html:

CURLINFO_RESPONSE_CODE

Pass a pointer to a long to receive the last received HTTP or FTP code. This option was known as CURLINFO_HTTP_CODE in libcurl 7.10.7 and earlier. This will be zero if no server response code has been received. Note that a proxy's CONNECT response should be read with CURLINFO_HTTP_CONNECTCODE and not this.

CURLINFO_HTTP_CONNECTCODE

Pass a pointer to a long to receive the last received proxy response code to a CONNECT request.
*/
        curl_error = curl_easy_getinfo(curl, CURLINFO_HTTP_CONNECTCODE, &http_error_code);
#if USE_CURL_VERBOSE_MODE
        printf("CURLINFO_HTTP_CONNECTCODE = %ld\n", http_error_code);
#endif
        if (curl_error)
        {
                goto cleanup;
        } else if (http_error_code != 200) {
                curl_error = CURLE_COULDNT_CONNECT; // just set generic error, otherwise need to parse all HTTP response error codes
        }
#endif

cleanup:
        /* always cleanup */
        curl_formfree(post_chunks);
        curl_easy_cleanup(curl);
        curl_slist_free_all(header_tags);
        fclose(fp);

        return curl_error;

}


