#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4.QtNetwork import QNetworkRequest, QNetworkReply
import HTMLParser, re, os
from urlparse import urlparse
import urllib2, time
from utils.htmlTools import htmlTools
from utils.DebugLog import DebugLog
from Extractor import Extractor
from model.RideModel import Ride

class TableParserRERratp(Extractor, HTMLParser.HTMLParser):

   def __init__(self):
      DebugLog("TableParserRERratpMobi::Init")

      HTMLParser.HTMLParser.__init__(self)
      self.Clear()

   def Clear(self):
      self.tagHeureMission = False
      self.tagDestination = False
      self.tagTrainA = False
      self.tagHeurePassageB = False
      self.tagError = False
      Extractor.Clear(self)
      self.stopParsing = False

   def Feed(self,  html):
      DebugLog("TableParserRERratp::Feed %s"%self.id)
      self.Clear()
      self.html = htmlTools.unescape(html.strip().decode('iso-8859-1'))
      self.feed(self.html)

   def handle_starttag(self, tag, attrs):
      if tag=='div':
         if dict(attrs).has_key('class'):
            if dict(attrs)['class'] == 'bg1' or dict(attrs)['class'] == 'bg3':
               self.tagDestination = True
               self.currentRide = Ride()

            elif dict(attrs)['class'] == 'schmsg1' or dict(attrs)['class'] == 'schmsg3':
               self.tagHeureMission = True

            elif dict(attrs)['class'] == 'error':
               DebugLog("  Error found!")
               self.tagError = True

         elif dict(attrs).has_key('id') and dict(attrs)['id']=='message':
            DebugLog("  Error found!")
            self.tagError = True

      elif self.tagHeureMission and tag == 'b':
         self.tagHeurePassageB = True

      elif self.tagHeureMission and tag == 'a':
         self.tagTrainA = True

         if dict(attrs)['href']:
            url = dict(attrs)['href']
            url = 'http://wap.ratp.fr/siv/'+re.sub(';jsessionid=.+?\?', '?', url)+"&exid=%f"%(1000*time.clock())
            DebugLog(url)
            self.currentRide.detailsUrl = url
            self.parseDetails = True

   def handle_data(self, data):
      if self.tagDestination:
         u = data.replace('>', '').strip()
         self.currentRide.setDestination(u)

      if self.tagTrainA:
         self.currentRide.setTrain(data.strip())

      if self.tagHeurePassageB:
         heure = data.strip()
         voie=''
         res = re.search("(.*?)\s*(?:D.part)?\s*[vV]\.?(?:oie)?\s?(\d+)", heure)
         if res:
            heure = res.group(1).strip().replace(':', 'h')
            voie = res.group(2).strip()

         self.currentRide.setVoie(voie)

         # On raccourcit 'Train a l'approche' et 'Train a quai'
         heure = heure.replace('Train ', '')
         self.currentRide.setHeure(heure)

      if self.tagError:
         if not self.currentRide:
            self.currentRide = Ride()
         self.currentRide.setError(self.currentRide.error+data.strip())
         DebugLog(data.strip())

   def handle_endtag(self, tag):
      if self.tagHeurePassageB and tag=='b' or self.tagError:
         if not self.tagError:
            self.tagHeurePassage = False
            self.tagHeurePassageB = False

         if self.currentRide.heure.lower()==u'sans arrêt':
            DebugLog("Sans Arret")
         else:
            self.listRides.append(self.currentRide)
         self.currentRide = None

      self.tagDestination ^= (self.tagDestination and tag=='div')
      self.tagTrainA ^= (self.tagTrainA and tag=='a')
      self.tagHeureMission ^= (self.tagHeureMission and tag=='div')
      self.tagError ^= (self.tagError and tag=='div')

   def fillModel(self, imax):
      DebugLog("TableParserRERratp::fillModel(%s)"%self.id)
      if self.sens!='A' and self.sens!='R':
         self.rideModel.SetInfo('ERROR', 'Sens du trajet indéfini: "%s"'%self.sens)

      self.AppendRidesToModel(imax)

   def MatchTrains(self, data, ride):
      DebugLog("Extractor::MatchTrains %s"%ride.train)

      ride.match=False

      stops = re.findall("missionstation-on.+?>(.+?)<", str(data))
          
      s = str(self.depart)
      s = re.sub("([âaàä])",  "a", s)
      s = re.sub("([éèêeë])", "e", s)
      s = re.sub("([iîï])",   "i", s)
      s = re.sub("([uüûù])",  "u", s)
      s = re.sub("([oôö])",   "o", s)
      s = re.sub("([\-\s'])", " ", s)

      if s in stops:
         DebugLog('   quick MATCH D %s'%s)
         ride.match=True
      else:
         DebugLog('   NO quick match D %s'%s)
         for stop in stops:
            if re.search(s, stop) or re.search(stop, s):
               DebugLog('match %s %s Dreturn'%(s,stop))
               ride.match=True
               break

         if not ride.match:
            DebugLog("   NO match D %s, return"%s)
            return
            
      s = str(self.arrivee)
      s = re.sub("([âaàä])",  "a", s)
      s = re.sub("([éèêeë])", "e", s)
      s = re.sub("([iîï])",   "i", s)
      s = re.sub("([uüûù])",  "u", s)
      s = re.sub("([oôö])",   "o", s)
      s = re.sub("([\-\s'])", " ", s)

      ride.match=False
      if ride in stops:
         DebugLog('   quick MATCH A %s'%s)
         ride.match=True
      else:
         DebugLog('   NO quick match %s'%s)

         for stop in stops:
            if re.search(s, stop) or re.search(stop, s):
               ride.match=True
               DebugLog('   MATCH A %s %s'%(s,stop))
               break

         if not ride.match:
            DebugLog("   NO match A %s, return"%s)
            return

   def ParsePerturbation(self, str):
      DebugLog("TableParserTransilien::ParsePerturbation")
      self.rideModel.ClearPerturbations()

      res = re.findall('<div class="trafic">(.+?)</div>', str, re.DOTALL)
      if res:
         for p in res:
            s = 'alt="\s%s".+?<b>.+?</b>(.+?)(?:<img.+?alt="RER")'%self.ligne
            r = re.search(s, p, re.DOTALL)

            if not r:
               s = 'alt="\s%s".+?<b>.+?</b>(.+?)(?:<b>Trafic normal)'%self.ligne
               r = re.search(s, p, re.DOTALL)
               if not r:
                  continue

            p=r.group(1)
            if not p:
               continue

            p=p.replace('\n',' ').replace('<br>', '\n')
            p=re.sub('\s+', ' ', p)
            p = re.sub('<.+?>', '', p).strip().replace('&#39;', "'")

            self.rideModel.AddPerturbation( unicode(p, 'utf-8') )

class ExtractorRERratp(TableParserRERratp):
   def __init__(self, ligne):
      DebugLog("ExtractorRERratpMobi::Init")

      Extractor.__init__(self, ligne.id)

      self.depart = ligne.depart
      self.arrivee = ligne.arrivee
      self.station = ligne.codeDepart
      self.ligne = ligne.ligne
      self.sens = ligne.direction
      lineTitle = ( ('R', self.ligne, 32), self.depart)
      self.rideModel.setIconTitle( lineTitle )

      self.urlPerturb = 'http://www.ratp.fr/informer/trafic/trafic.php?cat=2'
      urlMobi = 'http://wap.ratp.fr/siv/schedule?service=next&reseau=rer&lineid=R%s&directionsens=%s&stationid=%s'
      self.url = urlMobi%(self.ligne, self.sens, self.station)
      DebugLog(self.url)

      TableParserRERratp.__init__(self)
