#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os, sys, time
from PyQt4 import QtGui, QtCore
from PyQt4.QtCore import Qt
from utils.DebugLog import DebugLog, getScriptPath
from model.TrainTrainModel import TrainTrainModel
from view.RideView import RideView
from view.SettingsDlg import SettingsDlg
from view.AddRide import AddRideDlg
import version

class TrainTrainView(QtGui.QMainWindow):

   def __init__(self, argv, parent=None):
      QtGui.QMainWindow.__init__(self, parent)

      DebugLog("TrainTrainView::Init")
      self.offline = os.environ.has_key('OFFLINE')

      desktop = QtGui.QApplication.desktop()
      width = desktop.screenGeometry().width()
      height = desktop.screenGeometry().height()
      self.setMaximumSize(QtCore.QSize(width, width))
      self.setMinimumSize(QtCore.QSize(height, width))
      self.iconsPath = os.path.join(os.path.dirname(getScriptPath()), 'icons')

      try:
         self.setAttribute(QtCore.Qt.WA_Maemo5AutoOrientation, True)
      except AttributeError:
         # not on Maemo5
         self.setMaximumSize(QtCore.QSize(800, 800))
         self.setMinimumSize(QtCore.QSize(480, 800))
         pass

      self.setWindowTitle('TrainTrain')

      self.model = TrainTrainModel()
      self.model.SetOnline(True)
      self.views = dict()
      self.timer = QtCore.QTimer()
      self.connect(self.timer, QtCore.SIGNAL("timeout()"), self.Refresh)

      self.CreateAppLayouts()
      self.ReInit()

   def IconPath(self, str):
      return os.path.join(self.iconsPath, str)

   def ReInit(self):
      DebugLog("TrainTrainView::ReInit")

      self.updateCpt=0
      for view in self.views.values():
         self.RemoveView(view)
      self.model.InitDatas()
      self.PrepareView()
      self.SetLoading(True)

   def Settings(self):
      dlg = SettingsDlg()
      dlg.exec_()
      self.model.ReadConfig()
      self.timer.setInterval(self.model.ttConf.refreshRateSec()*1000)

   def AddRide(self):
      dlg = AddRideDlg(self.model.garesConf)
      dlg.exec_()
      ride = dlg.added
      if ride:
         rideModel = self.model.CreateAndAddRide(ride)
         self.AppendRideView(rideModel)

   def AddRideSimple(self):
      dlg = AddRideDlg()
      dlg.exec_()
      ride = dlg.added
      if ride:
         ride.id='simple'
         rideModel = self.model.CreateAndAddRide(ride, False)
         self.SetRideViewSimple(rideModel)

   def SetRideViewSimple(self, rideModel):
      view = RideView(rideModel, self)
      self.views[rideModel.id] = view
      self.vLayoutU.addWidget( view )
      view.Busy()

   def AppendRideView(self, rideModel):
      view = RideView(rideModel, self)
      self.views[rideModel.id] = view
      self.vLayout.addWidget( view )
      view.Busy()

   def PrepareView(self):
      DebugLog("TrainTrainView::PrepareView")
      for rideModel in self.model.GetRidesModel():
         self.AppendRideView(rideModel)

   def RemoveView(self, view):
      DebugLog("TrainTrainView::RemoveView(%s)"%view.model.id)
      self.model.RemoveRideModel(view.model)
      self.vLayout.removeWidget(view)
      del self.views[view.model.id]
      view.setParent(None)

   def CreateAppLayouts(self):
      DebugLog("TrainTrainView::CreateAppLayouts")

      addIcon = QtGui.QIcon(QtGui.QPixmap(self.IconPath('add48.png')))
      add = QtGui.QAction(addIcon, u'Ajouter un trajet', self)
      add.setShortcut('Ctrl+A')
      self.connect(add, QtCore.SIGNAL('triggered()'),self.AddRide)

      update = QtGui.QAction(u'Rafraîchir', self)
      update.setShortcut('Ctrl+R')
      self.connect(update, QtCore.SIGNAL('triggered()'), self.Refresh)

      updateauto = QtGui.QAction(u'Rafraîchissement auto', self)
      updateauto.setShortcut('Ctrl+B')
      updateauto.setCheckable(True)
      self.connect(updateauto, QtCore.SIGNAL('triggered()'), self.RefreshAuto)

      settings = QtGui.QAction(u'Paramètres', self)
      settings.setShortcut('Ctrl+O')
      self.connect(settings, QtCore.SIGNAL('triggered()'), self.Settings)

      about = QtGui.QAction(u'A propos...', self)
      self.connect(about, QtCore.SIGNAL('triggered()'), self.About)

      menubar = self.menuBar()
      file = menubar.addMenu('&Options')
      file.addAction(add)
      file.addAction(update)
      file.addAction(updateauto)
      file.addAction(settings)
      file.addAction(about)

      self.vLayout = QtGui.QVBoxLayout()
      self.vLayout.setSpacing(0)
      self.vLayout.setMargin(0)
      self.vLayout.setAlignment(Qt.AlignTop)

      self.tLayout = QtGui.QVBoxLayout()
      self.tLayout.setSpacing(0)
      self.tLayout.setMargin(0)
      self.tLayout.addLayout(self.vLayout)
      addButton = QtGui.QPushButton('Ajouter un trajet')
      addButton.clicked.connect(self.AddRide)
#      addButton.setStyleSheet('background-color:#2684DB; color: #fff; ')

      self.tLayout.addWidget(addButton)
      self.scrollArea = self.CreateScrollWidget(self.tLayout)

      self.vLayoutU = QtGui.QVBoxLayout()
      self.vLayoutU.setSpacing(0)
      self.vLayoutU.setMargin(0)
      self.vLayoutU.setAlignment(Qt.AlignTop)

      addButtonU = QtGui.QPushButton('Voir un trajet simple')
      addButtonU.clicked.connect(self.AddRideSimple)
      self.vLayoutU.addWidget(addButtonU)

      self.scrollAreaU = self.CreateScrollWidget(self.vLayoutU)

      self.tabW = QtGui.QTabWidget()
      self.tabW.setTabPosition(QtGui.QTabWidget.East)

      rotate = QtGui.QTransform().rotate(-90)
      self.iconFav = QtGui.QIcon( QtGui.QPixmap(self.IconPath('mestrainsfav.png')).transformed(rotate) )
      self.iconSim = QtGui.QIcon( QtGui.QPixmap(self.IconPath('mestrains.png')).transformed(rotate) )

      self.tabW.addTab(self.scrollArea, self.iconFav, '')
      self.tabW.addTab(self.scrollAreaU, self.iconSim, '')
      self.tabW.setIconSize( QtCore.QSize(48, 48) )
      self.tabW.setStyleSheet(' \
         QTabBar::tab { \
              background: #194F97; \
/*              border: 1px solid #194F97; */\
              } \
            \
          QTabBar::tab:selected, QTabBar::tab:hover { \
              background: #2684DB; \
/*              background: qlineargradient(x1: 0, y1: 0, x2: 1, y2: 0, stop: 0 #194F97, stop: 1.0 #2684DB);*/ \
          } ')
      
      self.setCentralWidget(self.tabW)
#      self.setCentralWidget(self.scrollArea)

      self.connect(self.model, QtCore.SIGNAL('extracted'), self.Extracted, QtCore.Qt.QueuedConnection)
      self.connect(QtGui.QApplication.desktop(), QtCore.SIGNAL('resized(int)'), self.Resized)

   def CreateScrollWidget(self, layout):
      scrollArea = QtGui.QScrollArea(self)
      scrollArea.setWidgetResizable(True)
      scrollAreaWidgetContents = QtGui.QWidget(scrollArea)
      scrollAreaWidgetContents.setObjectName('scroll')
      scrollAreaWidgetContents.setLayout( layout )
      scrollAreaWidgetContents.setStyleSheet("QWidget#scroll { background: #fff; margin: 0; padding: 0;} ")
      scrollArea.setWidget(scrollAreaWidgetContents)
      return scrollArea

   def Resized(self, val):
      desktop = QtGui.QApplication.desktop()

      angle=0
      if desktop.screenGeometry().width() > desktop.screenGeometry().height():
         self.tabW.setTabPosition(QtGui.QTabWidget.East)
         angle=-90
      else:
         self.tabW.setTabPosition(QtGui.QTabWidget.South)
         angle=90

      rotate = QtGui.QTransform().rotate(angle)
      for tab in range(0, self.tabW.count()):
         icon = self.tabW.tabIcon(tab)
         pix = icon.pixmap(QtCore.QSize(48,48))
         pix = pix.transformed( rotate )
         icon = QtGui.QIcon(pix)
         self.tabW.setTabIcon(tab, icon)

   def Refresh(self):
      DebugLog("TrainTrainView::Refresh")
      self.updateCpt=0
      self.SetLoading(True)

      for view in self.views.values():
         view.Busy()
      self.model.RefreshDatas()

   def RefreshAuto(self):
      if self.timer.isActive():
         self.timer.stop()
      else:
         self.timer.setInterval(self.model.ttConf.refreshRateSec()*1000)
         self.timer.start()

   def Extracted(self, rideModel):
      DebugLog("TrainTrainView::Extracted")
      self.updateCpt+=1
      self.views[rideModel.id].UpdateRides()

      if self.updateCpt>=len(self.views):
         self.SetLoading(False)

   def SetLoading(self, b):
      try:
         self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, b)
      except AttributeError:
         # not on Maemo5
         pass

   def About(self):
      v = version.appVersion
      QtGui.QMessageBox.about(self, "A propos",
      u'TrainTrain %s\nDéveloppé par Gérald Fauvelle\nhttp://projects.forum.nokia.com/TrainTrain'%v)
      return

   def closeEvent(self, event):
      if self.model.garesConf.hasChanged:
         self.model.garesConf.Write()
      event.accept()
