﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4.QtNetwork import QNetworkRequest
import HTMLParser,  re
import ConfigParser
from urlparse import urlparse
from utils.htmlTools import htmlTools
from utils.DebugLog import DebugLog, DebugFile
from Extractor import Extractor
from model.RideModel import Ride

class TableParserMetro(Extractor, HTMLParser.HTMLParser):

   def __init__(self):
      DebugLog("TableParserMetro::Init")

      HTMLParser.HTMLParser.__init__(self)
      self.Clear()

   def Clear(self):
      self.tagHeurePassage = False
      self.tagHeurePassageB = False
      self.tagDestination = False
      self.tagDestinationB = False
      self.tagError = False
      self.station = False
      self.noTrain = False
      self.train = ''
      Extractor.Clear(self)
      self.stopParsing = False

   def Feed(self, html):
      self.Clear()
      self.html = htmlTools.unescape(html.strip().decode('iso-8859-1'))
      self.feed(self.html)

   def handle_starttag(self, tag, attrs):
      if (tag == 'div' and dict(attrs).has_key('class') ):
         if dict(attrs)['class'] == 'bg1' or dict(attrs)['class'] == 'bg3':
            self.tagDestination = True
            self.currentRide = Ride()

         elif dict(attrs)['class'] == 'schmsg1' or dict(attrs)['class'] == 'schmsg3':
            self.tagHeurePassage = True

      elif self.tagHeurePassage and tag == 'b':
         self.tagHeurePassageB = True
         
      elif self.tagDestination and tag == 'b':
         self.tagDestinationB = True

   def handle_data(self, data):
      if self.tagDestination:
         u = data.replace('>', '').strip()
         self.currentRide.setDestination(u)
         
      if self.tagDestinationB:
         u = data.replace('>', '').strip()
         self.currentRide.setDestination(u)

      if self.tagHeurePassageB:
         heure = data.strip()
         # On raccourcit 'Train a l'approche' et 'Train a quai'
         heure = heure.replace('Train ', '')
         self.currentRide.setHeure(heure)

      if self.noTrain:
         self.currentRide = Ride()
         self.currentRide.setTrain(u'Aucun train pour ce trajet')

   def handle_endtag(self, tag):
      if self.tagError:
         self.listRides.append(self.currentRide)
         self.currentRide = None
   
      if self.tagHeurePassageB and tag=='b':
         self.tagHeurePassage = False
         self.tagHeurePassageB = False
         self.listRides.append(self.currentRide)
         self.currentRide = None

      if self.tagDestination and tag=='div':
         self.tagDestination = False
         
      if self.tagDestinationB and tag=='b':
         self.tagDestinationB = False
         self.tagDestination = False

      if self.noTrain:
         self.listRides.append(self.currentRide)
         self.currentRide = None
         self.noTrain ^= (self.noTrain and tag == 'div')

   def fillModel(self, imax):
      DebugLog("TableParserTransilien::fillModel")
      self.AppendRidesToModel(imax)
      self.perturbation='perturb'
      return self.perturbation, self.error

   def ParsePerturbation(self, str):
      DebugLog("TableParserTransilien::ParsePerturbation")

      res = re.findall('<div class="trafic">(.+?)</div>', str, re.DOTALL)
      if res:
         for perturbation in res:
            p = re.sub('<.+?>', '',perturbation).strip().replace('&#39;', "'")
            if p.find('Trafic normal')==-1:
               self.rideModel.AddPerturbation( unicode(p, 'utf-8') )

class ExtractorMetro(TableParserMetro):
   def __init__(self, ligne):
      DebugLog("ExtractorMetro::Init")

      Extractor.__init__(self, ligne.id)

      self.depart = ligne.depart
      self.station = ligne.codeDepart
      self.ligne = ligne.ligne
      self.sens = ligne.direction
      lineTitle = ( ('M', self.ligne, 32), self.depart)
      self.rideModel.setIconTitle( lineTitle )

      urlMobi = 'http://wap.ratp.fr/siv/schedule?service=next&reseau=metro&lineid=M%s&directionsens=%s&stationid=%s'
      self.url = urlMobi%(self.ligne, self.sens, self.station )
      DebugLog(self.url)
      self.urlPerturb = 'http://www.ratp.fr/informer/trafic/trafic.php?cat=1'

      TableParserMetro.__init__(self)
