#!/usr/bin/python
# -*- coding: utf-8 -*-

from DebugLog import DebugLog
from ConfigParser import ConfigParser
import sys, sqlite3, os

class ConfFile:
   def __init__(self, fichier):
      self.config = ConfigParser()
      self.config.read(fichier)

   def get(self, section, key):
      try:
         return self.config.get(section, key)
      except:
         return ''

class Ride:
   def __init__(self, ligne, tec, depart, arrivee, codeDepart, codeArrivee, exploitant, direction):
      self.ligne = ligne
      self.tec = tec
      self.depart = depart
      self.codeDepart = codeDepart
      self.arrivee = arrivee
      self.codeArrivee = codeArrivee
      self.exploitant = exploitant
      self.direction = direction

class RidesConfig:
   def __init__(self, filename):
      DebugLog("RidesConfig::__init__")
      self.rides=dict()
      self.hasChanged = False
      self.filename = filename

   def AddRide(self, ride, id=''):
      DebugLog("RidesConfig::AddRide(%s)"%id)
      self.hasChanged = True
      if not id or id in self.rides.keys():
         id = 'Ride%d'%(self.LastId()+1)
         DebugLog("  RidesConfig::AddRide(create id%s)"%id)
      self.rides[id] = ride
      ride.id = id
      DebugLog(str([k for k in sorted(self.rides.keys())]))

   def RemoveRide(self, id):
      DebugLog("RidesConfig::RemoveRide(%s)"%id)
      del self.rides[id]
      DebugLog(str([k for k in sorted(self.rides.keys())]))
      self.hasChanged = True

   def GetRides(self):
      return [self.rides[k] for k in sorted(self.rides.keys())]

   def LastId(self):
      strid = sorted(self.rides.keys(), reverse=True)[0]
      return int(strid[4:])
      
   def ReadRides(self):
      DebugLog("RidesConfig::ReadRides")
      self.rides=dict()
      t = ConfFile(self.filename)
      
      for section in t.config.sections():
         ligne = t.get(section, 'ligne')
         tec = t.get(section, 'tec')
         depart = t.get(section, 'depart')
         arrivee = t.get(section, 'arrivee')
         codeDepart = t.get(section, 'codeDepart')
         codeArrivee = t.get(section, 'codeArrivee')
         exploitant = t.get(section, 'exploitant')
         direction = t.get(section, 'direction')

         l = Ride(ligne, tec, depart, arrivee, codeDepart, codeArrivee, exploitant, direction)
         self.AddRide(l, section)
         
      self.hasChanged = False

   def Write(self):
      self.WriteRides()
      self.hasChanged = False

   def WriteRides(self, filename=''):
      if not filename:
         filename = self.filename
         
      DebugLog("RidesConfig::WriteRides(%s)"%filename)
      
      f = open(filename, 'w')
      t = ConfigParser()
      iride=1

      DebugLog("nb rides=%d"%len(self.rides.values()))
      
      for k in sorted(self.rides.keys()):
         ride = self.rides[k]
         key="Ride%d"%iride
         t.add_section(key)
         t.set(key, 'TEC', ride.tec)
         t.set(key, 'Ligne', ride.ligne)
         t.set(key, 'depart', ride.depart)
         t.set(key, 'arrivee', ride.arrivee)
         t.set(key, 'codeDepart', ride.codeDepart)
         t.set(key, 'codeArrivee', ride.codeArrivee)
         t.set(key, 'exploitant', ride.exploitant)
         if ride.direction:
            t.set(key, 'direction', ride.direction)
         iride += 1

      t.write(f)


class TrainTrainConf:
   def __init__(self):
      confDir = os.path.join(os.path.expanduser('~'),".traintrain")
      if not os.path.exists(confDir):
         os.makedirs(confDir)
      self.conf = os.path.join(confDir, "traintrain.conf")

      self.ReadConfig() 

   def ReadConfig(self):
      self.nb = 2
      if os.path.exists(self.conf):
         t = ConfigParser()
         t.read(self.conf)
         try:
            self.nb = int(t.get('trajets', 'nbtrains'))
         except:
            pass
      else:
         self.WriteConfig(self.nb)

   def WriteConfig(self, nb):
      f = open(self.conf, 'w')
      t = ConfigParser()

      t.add_section('trajets')
      t.set('trajets', 'nbtrains', nb)
      t.write(f)
      
   def nbTrains(self):
      return self.nb
      