﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import os, re
from urlparse import urlparse
from PyQt4 import QtCore
from PyQt4.QtNetwork import QNetworkRequest, QNetworkAccessManager, QNetworkProxy, QNetworkReply
import HTMLParser
from DebugLog import DebugLog, DebugFile
from RideModel import RideModel, Ride

class Extractor(QtCore.QObject):
   def __init__(self, id):
      DebugLog("Extractor::Init")
      QtCore.QObject.__init__(self)

      self.url = ""
      self.rideModel = RideModel(id)
      self.parser = None
      self.treestore = None
      self.max = 0
      self.fetching = False
      self.id = id

      self.online = True
      self.manager = None
      self.parsePerturbation =  False

   def Clear(self):
      self.liste_train = []
      self.liste_horaire = []
      self.liste_destination = []
      self.liste_voie = []
      self.perturbation = ""
      self.error = ""

   def SetOnline(self, b):
      self.online = b

   def InitNetwork(self):
      DebugLog("Extractor::InitNetwork")

      self.manager = QNetworkAccessManager()
      self.connect(self.manager, QtCore.SIGNAL("finished(QNetworkReply *)"), self.readResponse )

      proxy = os.environ.get('PROXY')
      if proxy:
         o = urlparse(proxy)
         netlocL = o.netloc.find(':')
         host = o.netloc[:netlocL]
         DebugLog("  - Using proxy : %s://%s:%d"%(o.scheme, host, o.port))
         self.proxy = QNetworkProxy(QNetworkProxy.HttpProxy, host, o.port)
         self.manager.setProxy(self.proxy)

   def SetOnline(self, b):
      self.online = b
      if self.online:
         self.InitNetwork()

   def FetchDatas(self, model, max):
      DebugLog("Extractor::FetchDatas")
      if self.fetching:
         return

      self.fetching = True
      self.max = max
      self.model = model
      self.rideModel.Clear()

      if self.online and self.manager:
         request = QNetworkRequest( QtCore.QUrl(self.url) )
         reply = self.manager.get(request)
         self.connect(reply, QtCore.SIGNAL("downloadProgress(qint64, qint64)"), self.updateBar)

      else:
         data = open('HSL-EM.htm', 'r').read()
         #data = open('LaTourMaubourg8A.htm').read()

         self.Parse(data)

   def updateBar(self, read,total):
      self.rideModel.SetProgress(read, total)

   def readResponse(self, reply):
      DebugLog("Extractor::readResponse")
      error = reply.error()

      # test d'erreur, en général, pas de connection internet
      if error != QNetworkReply.NoError:
         self.rideModel.SetInfo('ERROR', u"Erreur, vérifiez votre connection Internet")

      html = str(reply.readAll())
      #DebugFile(html)

      if not self.parsePerturbation:
         self.Parse(html)
      else:
         self.ParsePerturbation(html)
         self.parsePerturbation = False

      self.emit(QtCore.SIGNAL('extracted'), self.rideModel)
      self.fetching = False

   def Parse(self, str):
      DebugLog("Extractor::Parse")

      try:
         self.Feed( str )
      except HTMLParser.HTMLParseError, e:
         print e

      perturbation, error = self.fillModel(self.max)

      if perturbation:
         o = urlparse(self.url)
         urlPerturbation = "%s://%s%s"%(o.scheme, o.netloc, perturbation)
         self.parsePerturbation =  True
         request = QNetworkRequest( QtCore.QUrl( urlPerturbation ) )
         self.manager.get(request)
         
      if error:
         self.rideModel.SetInfo('ERROR', error)

   def ParsePerturbation(self, str):
      DebugLog("Extractor::ParsePerturbation")

      res = re.findall('<div id="icv".+?>(.+?)</div>', str, re.DOTALL)
      if res:
         for perturbation in res:
            self.rideModel.AddPerturbation( perturbation.strip().replace('&#39;', "'") )


   def AppendRidesToModel(self, imax):
      DebugLog("Extractor::AppendRidesToModel")
      cpt = 0
      for code in self.liste_train:
         ride = Ride(code,
                        self.liste_horaire[cpt],
                        self.liste_destination[cpt],
                        self.liste_voie[cpt]
                        )
         self.rideModel.addRide(ride)
         cpt += 1
         if imax>0 and cpt>=imax:
            break
