# -*- coding: utf-8 -*-
import gtk, hildon, gobject

logfile = '/home/user/.local/share/tracker/trackerd.log'

class LogView(hildon.StackableWindow):
  def __init__(self):
    hildon.StackableWindow.__init__(self)
    self.set_title('trackerd log')
    textview = hildon.TextView()
    textbuffer = gtk.TextBuffer()
    self.log = open(logfile, 'r')
    textview.set_buffer(textbuffer)
    textview.set_editable(False)
    textview.set_wrap_mode(gtk.WRAP_WORD)
    self.id = gobject.timeout_add(200, tail, self.log, textbuffer, textview)
    pa = hildon.PannableArea()
    pa.add(textview)
    self.add(pa)
    self.show_all()

  def __del__(self):
    gobject.source_remove(self.id)
    self.log.close()

def tail(fd, buf, view):
  txt = fd.read()
  if txt:
    mark = buf.create_mark("end", buf.get_end_iter())
    view.scroll_to_mark(mark, 0)
    buf.insert_at_cursor(txt)
    buf.delete_mark_by_name("end")
  return True

if __name__=="__main__":
  logfile = 'logtest'
  hw = LogView()
  gtk.main()
