/*
 * This file is part of TpSession
 *
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * Contact Kate Alhola  kate.alholanokia.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "tpsession.h"
#include <QDebug>

TpSession::TpSession(QString cmname,bool synchronous)
{
    Tp::registerTypes();
    Tp::enableDebug(false);
    Tp::enableWarnings(false);

    mAM = Tp::AccountManager::create();
    reqCm=cmname;
    connect(mAM->becomeReady(),
            SIGNAL(finished(Tp::PendingOperation *)),
            SLOT(onAMReady(Tp::PendingOperation *)));
    connect(mAM.data(),
            SIGNAL(accountCreated(const QString &)),
            SLOT(onAccountCreated(const QString &)));

   // createObserver();
  if(synchronous) loop.exec(); // Loop locally untill accounts are initialized
   reqCm=cmname;

}
TpSession* TpSession::instancePtr=NULL;
TpSession* TpSession::instance(bool synchronous)
{
    if(instancePtr==NULL) instancePtr=new TpSession("ring",synchronous);
    return instancePtr;
};

void TpSession::onAMReady(Tp::PendingOperation *op)
{
 qDebug() << "TpSession::onAMReady";
 TpSessionAccount *tpacc;

   foreach (const QString &path, mAM->allAccountPaths()) {
       accounts+=tpacc=new TpSessionAccount(mAM, path);
       connect(tpacc,SIGNAL(accountReady(TpSessionAccount*)),
                      SLOT(onAccountReady(TpSessionAccount *)));
    }

}

void TpSession::onReady(Tp::PendingOperation *)
{
};

void TpSession::onAccountCreated(const QString &path)
{

    accounts+=new TpSessionAccount(mAM, path);
}

void TpSession::onAccountReady(TpSessionAccount *tpacc)
{
    qDebug() << "TpSession::onAccountReady:Account " << tpacc->acc->cmName() << "is Ready";
    connect(tpacc,SIGNAL(messageReceived(const Tp::ReceivedMessage &,TpSessionAccount *)),
                  SLOT(onMessageReceived(const Tp::ReceivedMessage &,TpSessionAccount *)));
    if(!reqCm.isEmpty() && tpacc->acc->cmName()==reqCm) {
    if(sync) {
        sync=false;
        loop.quit();
        emit accountReady(tpacc);
     if(!reqMsg.isEmpty()) tpacc->sendMessageToAddress(reqAddress,reqMsg);
    }
  }
}

void TpSession::onMessageReceived(const Tp::ReceivedMessage &msg,TpSessionAccount *acc)
{
    qDebug() << "TestProg::onMessageReceived " << msg.text() << "from " << msg.sender()->id();
    emit messageReceived(msg,acc);
}

void TpSession::sendMessageToAddress(QString connectionMgr,QString address,QString message)
{
 TpSessionAccount *tpsa=getAccount(connectionMgr);
 if(tpsa) tpsa->sendMessageToAddress(address,message);
}

TpSessionAccount* TpSession::getAccount(const  QString cm,QString protocol)
{
 qDebug() << "TpSession::getAccount" << cm << " " << protocol;
 foreach (TpSessionAccount *tpacc, accounts) {
     if((!cm.isEmpty()  && tpacc->acc->cmName()==cm) || (!protocol.isEmpty() && tpacc->acc->protocol()==protocol)) {
     qDebug() << "TpSession::getAccount found" << tpacc->acc->cmName() << " " << tpacc->acc->protocol();
     return tpacc;
     }
 }
 return NULL;
}

void TpSession::createObserver()
{

    qDebug() << __PRETTY_FUNCTION__ ;

    registrar = Tp::ClientRegistrar::create();

    Tp::ChannelClassList channelFilters;
    QMap<QString, QDBusVariant> textFilter, mediaFilter;
    // Registering Text channel observer
    textFilter.insert(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".ChannelType"),
                  QDBusVariant(TELEPATHY_INTERFACE_CHANNEL_TYPE_TEXT));
    textFilter.insert(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".TargetHandleType"),
                  QDBusVariant(Tp::HandleTypeContact));
    channelFilters.append(textFilter);

    // Registering Media channel observer
    mediaFilter.insert(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".ChannelType"),
                  QDBusVariant(TELEPATHY_INTERFACE_CHANNEL_TYPE_STREAMED_MEDIA));
    mediaFilter.insert(QLatin1String(TELEPATHY_INTERFACE_CHANNEL ".TargetHandleType"),
                  QDBusVariant(Tp::HandleTypeContact));
    channelFilters.append(mediaFilter);

    TpSessionObserver* observer = new TpSessionObserver( channelFilters, this );
    bool registered = registrar->registerClient(
      Tp::AbstractClientPtr::dynamicCast(Tp::SharedPtr<TpSessionObserver>(observer)),
      "TpSessionChannelObserver");

        qDebug() << "TpSession::createObserver" << (registered ? "started" : "failed");

}


void TpSession::createChannelListener(const QString &channelType,
                                   const Tp::MethodInvocationContextPtr<> &context,
                                   const Tp::AccountPtr &account,
                                   const Tp::ChannelPtr &channel)
{
    qDebug() << "TpSession::createChannelListener";

    QString channelObjectPath = channel->objectPath();


    if ( channels.contains( channelObjectPath ) &&
         !channelType.isEmpty() &&
         !channelObjectPath.isEmpty() ) {
        qDebug() << "TELEPATHY_ERROR_INVALID_ARGUMENT";
        return;
    }
    qDebug() << "creating listener for: " << channelObjectPath << " type " << channelType;
#if 0
    ChannelListener* listener = 0;
    if( channelType == TELEPATHY_INTERFACE_CHANNEL_TYPE_TEXT ) {
        listener = new TextChannelListener(account, channel, context);
    } else if ( channelType == TELEPATHY_INTERFACE_CHANNEL_TYPE_STREAMED_MEDIA ) {
        listener = new StreamChannelListener(account, channel, context);
    }

    if(listener) {
        connect(listener, SIGNAL(channelClosed(ChannelListener *)),
                this, SLOT(channelClosed(ChannelListener *)));
        Channels.append( channelObjectPath );
    }
#endif
}








