/*
 * requests.h -- Manage all network requests
 *
 * Copyright (C) 2010 Andrea Grandi
 * Authors: Andrea Grandi <a.grandi@gmail.com>
 *
 * This file is part of LastGo and is published under the GNU GPLv2
 * See the README file for more details.
 */

#ifndef REQUESTS_H
#define REQUESTS_H

#include <QObject>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QMap>

#define LASTFM_BASE_URL "http://ws.audioscrobbler.com/2.0/"
#define LASTFM_HANDSHAKE_URL "http://post.audioscrobbler.com:80/"

class Requests : public QObject
{
    Q_OBJECT
public:
    explicit Requests(QObject *parent = 0);
    void apiRequest(QString url);
    void apiRequestPost(QString url, QByteArray params);

private:
    QNetworkAccessManager *manager;
    QNetworkReply *reply;

signals:
    void dataAvailable(QString value);

public slots:

private slots:
    void apiRequestReplied(QNetworkReply *reply);

};

#endif // REQUESTS_H
