#include "mainwindow.h"
#ifdef Q_WS_MAEMO_5
#include <QtMaemo5>
#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
void MainWindow::grabZoomKeys(bool grab)
     {
         if (!winId()) {
             qWarning("Can't grab keys unless we have a window id");
             return;
         }


         unsigned long val = (grab) ? 1 : 0;
         Atom atom = XInternAtom(QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", False);
         if (!atom) {
             qWarning("Unable to obtain _HILDON_ZOOM_KEY_ATOM. This will only work "
                      "on a Maemo 5 device!");
             return;
         }


         XChangeProperty (QX11Info::display(),
                 winId(),
                 atom,
                 XA_INTEGER,
                 32,
                 PropModeReplace,
                 reinterpret_cast<unsigned char *>(&val),
                 1);
     }
#endif

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{


metaInformationResolver = new Phonon::MediaObject(this);

    ui.setupUi(this);


    scene = new QGraphicsScene;
    ui.graphicsView->setScene(scene);
    QBrush br(Qt::NoBrush);

scene->setForegroundBrush(br);
    scene->setBackgroundBrush(br);

moo = new Phonon::MediaObject;;
device = new Phonon::AudioOutput;
Phonon::createPath(moo, device);



slider = new Phonon::SeekSlider(ui.widget_2);
volume=new Phonon::VolumeSlider(ui.widget_2);
ui.verticalLayout_3->addWidget(slider);
ui.verticalLayout_3->addWidget(volume);
slider->setMediaObject(moo);
volume->setAudioOutput(device);

volume->setOrientation(Qt::Horizontal);


opt=new options();
rotate=0;
load();


//opt->load(rotate,ui.listWidget->font().toString(),listWidget->font().pointSize());



mmenu=new QMenu ();
QMenu *mmenut=new QMenu ("Tools");
mmenut->addAction("Download art",this,SLOT(dart()));
mmenut->addAction("Download all art",this,SLOT(dart2()));
mmenu->addAction("Information",this,SLOT(inform()));
mmenu->addMenu(mmenut);
mmenut->addAction("Options",opt,SLOT(exec()));
mmenu->addAction("About",this,SLOT(about()));
mmenu->addAction("Quit",qApp,SLOT(quit()));




connect (opt,SIGNAL(accepted()),this,SLOT(load()));
          connect(metaInformationResolver, SIGNAL(stateChanged(Phonon::State,Phonon::State)), this, SLOT(metaStateChanged(Phonon::State,Phonon::State)));
          connect(ui.pushButton,SIGNAL(clicked()),this,SLOT(click1()));
          connect(ui.pushButton_2,SIGNAL(clicked()),this,SLOT(click2()));
          connect(ui.pushButton_3,SIGNAL(clicked()),this,SLOT(click3()));
          connect(ui.pushButton_4,SIGNAL(clicked()),this,SLOT(click4()));
          connect(ui.pushButton_5,SIGNAL(clicked()),this,SLOT(click5()));
          connect(ui.pushButton_11,SIGNAL(clicked()),this,SLOT(pl_fn_click()));
          connect(ui.pushButton_7,SIGNAL(clicked()),moo,SLOT(pause()));
          connect(ui.pushButton_7,SIGNAL(clicked()),moo,SLOT(stop()));
          connect(ui.pushButton_6,SIGNAL(clicked()),this,SLOT(play_pause()));
          connect (ui.pushButton_8,SIGNAL(clicked()),this,SLOT(prev()));
          connect (ui.pushButton_9,SIGNAL(clicked()),this,SLOT(next()));
          connect(moo,SIGNAL(stateChanged(Phonon::State,Phonon::State)),this,SLOT(changePlay(Phonon::State,Phonon::State)));
          connect(ui.listWidget,SIGNAL(itemDoubleClicked(QListWidgetItem*)),this,SLOT(currentItemChanged(QListWidgetItem*)));
          connect(moo,SIGNAL(finished()),this,SLOT(next()));
          connect (ui.pushButton_12,SIGNAL(clicked()),mmenu,SLOT(show()));
click1();

QFile file("/home/user/.tplayer-list");
if (!file.open(QIODevice::ReadOnly | QIODevice::Text)){

    return;
}


QTextStream in(&file);
int row = in.readLine().toLong();
if (row==-1)return;
int p=0;
while (!in.atEnd()) {
    QString line = in.readLine();
 QStringList o=line.split(QString("%1%2").arg(QChar(9)).arg(QChar(1)));
 list.insert(p++,o);
}

drawlist();
ui.listWidget->setCurrentRow(row);
 moo->setCurrentSource(list.value(ui.listWidget->currentRow()).at(0));
#ifdef Q_WS_MAEMO_5
grabZoomKeys(true);
#endif

#ifdef Q_WS_MAEMO_5
QAbstractKineticScroller *scroller =ui.textEdit->property("kineticScroller").value<QAbstractKineticScroller *>();
scroller->setEnabled(true);
QAbstractKineticScroller *scroller2 =ui.textEdit_2->property("kineticScroller").value<QAbstractKineticScroller *>();
scroller2->setEnabled(true);
#endif

}



void MainWindow::keyPressEvent(QKeyEvent* event)
  {

      switch (event->key()) {
      case Qt::Key_F7:
device->setVolume(device->volume()+0.1);
        event->accept();
          break;


      case Qt::Key_F8:
         device->setVolume(device->volume()-0.1);
          event->accept();
          break;

      }


      QWidget::keyPressEvent(event);
  }



void MainWindow::inform(){
QDialog dg;
QString text="Filename : "+moo->currentSource().fileName()+"<br />";
 QMap<QString, QString> metaData = moo->metaData();
 QMapIterator<QString, QString> inf(metaData);
 while(inf.hasNext()){

     text+=inf.next().key()+" : "+inf.value()+"<br />";
 }
QScrollArea tu(&dg);
 QHBoxLayout *fg=new QHBoxLayout(&dg);
 fg->addWidget(&tu);

 QLabel t(QString(text),&tu);
tu.setWidget(&t);

// fg->addWidget(&t);
 t.setTextInteractionFlags(Qt::TextBrowserInteraction|Qt::TextSelectableByMouse);
dg.exec();
}

void MainWindow::load(){

    QFile file("/home/user/.tplayerrc");
            if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
                return;


            QStringList tyu=QString(file.readAll()).split("\n");
            rotate=tyu.at(0).toLong();
            QFont h(tyu.at(1));

            h.setPointSize(tyu.at(2).toLong());
            ui.listWidget->setFont(h);

            if (tyu.count()>4){
scrobler=new last(tyu.at(4),tyu.at(5));

}
            else{
                scrobler=new last("","");
                qDebug("no last.fm");
            }

file.close();
#ifdef Q_WS_MAEMO_5
 if (rotate==2){
 this-> setAttribute(Qt::WA_Maemo5AutoOrientation, true);
 }else if(rotate==1){
      setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
  }else{
       setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
  }
#endif
}



void MainWindow::about(){
    QDialog *dwidget=new QDialog(0);
    QLabel *text=new QLabel("<center><h3>TPlayer</h3></center><br />This program is distributed under terms of GNU GPL v3<br />" \
                            "Source code can be founded at <a href=\"http://googlecode.com/p/tplayer\">http://googlecode.com/p/tplayer</a><br /><br />" \
                            "Lead developer: <bold>Bonapart</bold><br />" \
                            "Web-developer : <bold>[VS]</bold>",dwidget);
    QPushButton *aqt=new QPushButton("AboutQt",dwidget);
    QVBoxLayout *mlay=new QVBoxLayout(dwidget);
    connect(aqt,SIGNAL(clicked()),qApp,SLOT(aboutQt()));
    mlay->addWidget(text);
    mlay->addWidget(aqt);


dwidget->exec();
}

MainWindow::~MainWindow()
{


    QFile file("/home/user/.tplayer-list");
         if (!file.open(QIODevice::WriteOnly | QIODevice::Text))
             return;

         QTextStream out(&file);
         int oi=ui.listWidget->currentRow();
         if (oi==-1 && ui.listWidget->count()>0)oi=0;
         out << QString("%1\n").arg(oi);
         QMapIterator<int, QStringList> i(list);
          while (i.hasNext()) {
              i.next();
             out<<i.value().join(QString("%1%2").arg(QChar(9)).arg(QChar(1)))<<"\n";
          }
        file.close();

}

void MainWindow::metaStateChanged(Phonon::State newState, Phonon::State /* oldState */)
{
    try{
 loading->setValue(loading->value()+1);

    if (newState == Phonon::ErrorState) {
        QMessageBox::warning(this, tr("Error opening files"),
            metaInformationResolver->errorString());

        queue.removeAt(queue.indexOf(metaInformationResolver->currentSource().fileName()));
        if (queue.count()> 0){

            metaInformationResolver->setCurrentSource(queue.first());

        }else{

                ld->close();
                    drawlist();
                }
        return;
    }

    if (newState != Phonon::StoppedState && newState != Phonon::PausedState)
        return;

    if (metaInformationResolver->currentSource().type() == Phonon::MediaSource::Invalid)
            return;

    QMap<QString, QString> metaData = metaInformationResolver->metaData();

    QString title = metaData.value("TITLE");
    if (title == "")
        title =metaInformationResolver->currentSource().fileName().split("/").last();

QString artist = metaData.value("ARTIST");
    if (artist=="")
        artist="Unknown";

QString album = metaData.value("ALBUM");
if (album=="")
    album="Unknown";
QString year = metaData.value("YEAR");
if (year=="")
    year="Unknown";
QString genre = metaData.value("GENRE");
if (genre=="")
    genre="Unknown";

list.insert(list.count(),QStringList()<< metaInformationResolver->currentSource().fileName()<<title<<artist<<genre<<album<<year);


queue.removeAt(queue.indexOf(metaInformationResolver->currentSource().fileName()));
if (queue.count() > 0){

        metaInformationResolver->setCurrentSource(queue.first());
    }
else{
    loading->setValue(42);
    ld->close();
        drawlist();
    }

}catch(int e){

}
}



void MainWindow::clear(){
    list.clear();
    ui.listWidget->clear();
}



void MainWindow::shuffle(){

QList<int> o;
for (int i=0;i<list.count();i++){
    o.append(i);

}

QMap<int,QStringList> list2;
for (int i=0;o.count()>0;i++){
    int y=rand()%o.count();
    list2.insert(o.at(y),list.value(i));
    o.removeAt(y);
}







list=list2;

//qSort(list.begin(), list.end(), randSort);
drawlist();

}



void MainWindow::next(){

    if ((float)moo->currentTime()/(float)moo->totalTime()>0.5)
        scrobler->addTrack(list.value(ui.listWidget->currentRow()),moo->totalTime());

if (ui.listWidget->count()==0)return;
    if (ui.listWidget->currentRow()<ui.listWidget->count()-1)
    ui.listWidget->setCurrentRow(ui.listWidget->currentRow()+1);
    else
        ui.listWidget->setCurrentRow(0);

     moo->setCurrentSource(list.value(ui.listWidget->currentRow()).at(0));
    moo->play();

}

void MainWindow::prev(){
    if (moo->currentTime()/moo->totalTime()>0.5)
        scrobler->addTrack(list.value(ui.listWidget->currentRow()),moo->totalTime());

if (ui.listWidget->count()==0)return;
    if (ui.listWidget->currentRow()>=0)
    ui.listWidget->setCurrentRow(ui.listWidget->currentRow()-1);
    else
        ui.listWidget->setCurrentRow(ui.listWidget->count()-1);

    moo->setCurrentSource(list.value(ui.listWidget->currentRow()).at(0));
    moo->play();

}

void MainWindow::play_pause(){

    if (moo->state()==Phonon::PlayingState )moo->pause();else moo->play();

}

void MainWindow::currentItemChanged ( QListWidgetItem * current ){
    if (moo->currentTime()/moo->totalTime()>0.5)
        scrobler->addTrack(list.value(ui.listWidget->currentRow()),moo->totalTime());

    moo->setCurrentSource(list.value(ui.listWidget->row(current)).at(0));
    moo->play();


}


void MainWindow::changePlay( Phonon::State newstate, Phonon::State oldstate ) {

    if (newstate==Phonon::PlayingState/*&&oldstate!=Phonon::PausedState*/){

scrobler->now(list.value(ui.listWidget->currentRow()),moo->totalTime());


    }

  //  if (newstate==Phonon::PlayingState|| newstate==Phonon::BufferingState ){
    ui.label->setText(list.value(ui.listWidget->currentRow()).at(2)+" - "+list.value(ui.listWidget->currentRow()).at(1));
    this->setWindowTitle(list.value(ui.listWidget->currentRow()).at(2)+" - "+list.value(ui.listWidget->currentRow()).at(1));
#ifdef Q_WS_MAEMO_5
    if (!this->isActiveWindow()){
   QMaemo5InformationBox *box=new QMaemo5InformationBox();
   QLabel *lbl=new QLabel("Now playing :"+list.value(ui.listWidget->currentRow()).at(2)+" - "+list.value(ui.listWidget->currentRow()).at(1),box);
  box->setWidget (lbl);
box->setTimeout(3000);
connect(box,SIGNAL(clicked()),this,SLOT(setFocus()));
box->exec();}
#endif


    QString apath=QString(list.value(ui.listWidget->currentRow()).at(2)).toLower();
    apath.replace("/","");
    QString bpath=QString(apath+" - "+list.value(ui.listWidget->currentRow()).at(4)).toLower();
    bpath.replace("/","");

    QString cpath="/home/user/.covers/";
    scene->clear();

    if (QFileInfo(cpath+bpath+".jpg").exists()){

        QPixmap *t=new QPixmap(cpath+bpath+".jpg");

         scene->addPixmap(t->scaled(ui.graphicsView->width(),ui.graphicsView->height(),Qt::KeepAspectRatio,Qt::FastTransformation));

    }else{
         if (QFileInfo(cpath+apath+".jpg").exists()){

            QPixmap *t=new QPixmap(cpath+apath+".jpg");
             //t= t->scaled(ui.graphicsView->width(),ui.graphicsView->height(),Qt::KeepAspectRatio,Qt::FastTransformation);
             scene->addPixmap(t->scaled(ui.graphicsView->width(),ui.graphicsView->height(),Qt::KeepAspectRatio,Qt::FastTransformation));


         }

}


    QFile file("/home/user/.bios/"+apath+".html");
    if (!file.exists()){
         QUrl url("http://team16.ru/grab.php?bio="+apath);

         QNetworkAccessManager *manager = new QNetworkAccessManager(this);

          connect(manager, SIGNAL(finished(QNetworkReply*)),
                  this, SLOT(replyFinished(QNetworkReply*)));


          manager->get(QNetworkRequest(url));
      }else{
          if (!file.open(QIODevice::ReadOnly|QFile::Text))  return ;

           QTextCodec *codec = QTextCodec::codecForName("UTF-8");

      ui.textEdit->setHtml( codec->toUnicode(file.readAll()));
    //  ui.textEdit->setHtml(file.readAll());
      file.close();
      }
  //}

}

void MainWindow::replyFinished(QNetworkReply*reply){

    QDir g;

    g.mkdir("/home/user/.bios");
    QFile file("/home/user/.bios/"+reply->url().toString().split("=").last()+".html");
        if (!file.open(QIODevice::WriteOnly))  return ;

  QString jk;
  QTextCodec *codec = QTextCodec::codecForName("UTF-8");

  jk=codec->toUnicode(reply->readAll());
  QTextStream out(&file);
        out <<jk;
        file.close();

    if (!file.open(QIODevice::ReadOnly|QFile::Text))  return ;
    QTextCodec *codec2 = QTextCodec::codecForName("UTF-8");
    ui.textEdit->setHtml( codec2->toUnicode(file.readAll()));
    file.close();

}


void MainWindow::dart(){
    QString apath=QString(list.value(ui.listWidget->currentRow()).at(2)).toLower().replace("/","");
    QString bpath=QString(list.value(ui.listWidget->currentRow()).at(4)).toLower().replace("/","");
    QUrl url;
if (list.value(ui.listWidget->currentRow()).at(4)!="Unknown")
    url.setUrl("http://team16.ru/grab.php?image="+apath+"&album="+bpath);
             else
    url.setUrl("http://team16.ru/grab.php?image="+apath);


    QNetworkAccessManager *manager = new QNetworkAccessManager(this);

     connect(manager, SIGNAL(finished(QNetworkReply*)),this, SLOT(replyFinished2(QNetworkReply*)));

     manager->get(QNetworkRequest(url));
}

void MainWindow::dart2(){
    for (int i=0;i<ui.listWidget->count();i++){
        ui.listWidget->setCurrentRow(i);
        dart();
    }
}



void MainWindow::replyFinished2(QNetworkReply*reply){
QByteArray data=reply->readAll();
    QDir g;
    QString fl;
    if (data==QString("404").toAscii()||data==QString("").toAscii()){
        if (reply->url().encodedQueryItems().count()!=1){
            QUrl url("http://team16.ru/grab.php?image="+reply->url().queryItems().at(0).second);
            QNetworkAccessManager *manager = new QNetworkAccessManager(this);

             connect(manager, SIGNAL(finished(QNetworkReply*)),this, SLOT(replyFinished2(QNetworkReply*)));

             manager->get(QNetworkRequest(url));
        }
        return;
    }
    if (reply->url().encodedQueryItems().count()==1)
fl=reply->url().queryItems().at(0).second;
    else
     fl=reply->url().queryItems().at(0).second+" - "+reply->url().queryItems().at(1).second;

    g.mkdir("/home/user/.covers");

    QFile file("/home/user/.covers/"+fl+".jpg");
    if (!file.open(QIODevice::WriteOnly)){
        qDebug(QString::number(file.error()).toAscii());
        return ;}

 file.write(data);
    file.close();



    QString apath=QString(list.value(ui.listWidget->currentRow()).at(2)).toLower().replace("/","");
    QString bpath=QString(apath+" - "+list.value(ui.listWidget->currentRow()).at(4)).toLower().replace("/","");

scene->clear();
    QString cpath="/home/user/.covers/";
    if (QFileInfo(cpath+bpath+".jpg").exists()){

        QPixmap *t=new QPixmap(cpath+bpath+".jpg");
        scene->addPixmap(t->scaled(ui.graphicsView->width(),ui.graphicsView->height(),Qt::KeepAspectRatio,Qt::FastTransformation));

    }else{
         if (QFileInfo(cpath+apath+".jpg").exists()){

            QPixmap *t=new QPixmap(cpath+apath+".jpg");
           scene->addPixmap(t->scaled(ui.graphicsView->width(),ui.graphicsView->height(),Qt::KeepAspectRatio,Qt::FastTransformation));

         }
}
}


void MainWindow::pl_fn_click(){
QMenu fh;
QMenu add("Add");
QMenu mv("Moving");
fh.addMenu(&add);
fh.addMenu(&mv);
//add.addAction("Track",this,SLOT(pl_fn_add_track()));
add.addAction("Directory",this,SLOT(pl_fn_add_dir()));
fh.addAction("Shuffle",this,SLOT(shuffle()));
fh.addAction("Clear",this,SLOT(clear()));
mv.addAction("To begin",ui.listWidget,SLOT(scrollToTop()));
mv.addAction("To end",ui.listWidget,SLOT(scrollToBottom()));
mv.addAction("Find",this,SLOT(find()));
 fh.exec(QCursor::pos());
}

void MainWindow::pl_fn_add_track(){

}

void MainWindow::find(){
    bool ok;
         QString text = QInputDialog::getText(this, tr("Searching "),
                                              tr("Part from name:"), QLineEdit::Normal,
                                              "", &ok);
         if (ok && !text.isEmpty())
         {
             QMapIterator<int,QStringList> i(list);
             while(i.hasNext()){
                 if (i.next().value().join(" ").toLower().indexOf(text.toLower())!=-1){
                     ui.listWidget->setCurrentRow(i.key());
                     return;
                 }
             }
         }
}

void MainWindow::pl_fn_add_dir(){
    int l=0;
    ld=new QDialog(0);
    loading=new QProgressBar(ld);
    connect(ld,SIGNAL(rejected()),this,SLOT(ch()));
    QString d;
    QString f=QFileDialog::getExistingDirectory(this,"Tplayer",QDesktopServices::storageLocation(QDesktopServices::MusicLocation),QFileDialog::ReadOnly);
    if (!f.isEmpty()){

        QDirIterator it(f, QDirIterator::Subdirectories);
        while (it.hasNext()) {
         d=it.next();
         QFileInfo hj(d);
          if (hj.isFile())
              if (QStringList(QStringList()<<"mp3"<<"flack"<<"ogg").indexOf(hj.suffix().toLower())>-1){
l++;
                  getMeta(d);
              }
    }
    }
    loading->setMaximum(l);
    loading->setValue(0);

    QHBoxLayout *iu=new QHBoxLayout(ld);
    iu->addWidget(loading);



    if (d!=""){
        ld->setModal(true);
        ld->show();
    metaInformationResolver->setCurrentSource(d);
   }



}

void MainWindow::ch(){
    //if (loading->value()<100)ld->show();
}

void MainWindow::drawlist(){
  //  ld->accept();
    ui.listWidget->clear();
    QMapIterator<int, QStringList> i(list);
     while (i.hasNext()) {
         i.next();
         ui.listWidget->addItem(i.value().at(2)+"-"+i.value().at(1));
     }
}

void MainWindow::getMeta(QString path){
queue.append(path);
}

void MainWindow::click1(){
    ui.frame_2->show();
    ui.frame_4->hide();
    ui.frame_6->hide();
    ui.frame_7->hide();
    ui.frame_8->hide();

}

void MainWindow::click2(){
    ui.frame_2->hide();
    ui.frame_4->show();
    ui.frame_6->hide();
    ui.frame_7->hide();
    ui.frame_8->hide();
}
void MainWindow::click3(){
    ui.frame_2->hide();
    ui.frame_4->hide();
    ui.frame_6->show();
    ui.frame_7->hide();
    ui.frame_8->hide();
}
void MainWindow::click4(){
    ui.frame_2->hide();
    ui.frame_4->hide();
    ui.frame_6->hide();
    ui.frame_7->hide();
    ui.frame_8->show();
}
void MainWindow::click5(){
    ui.frame_2->hide();
    ui.frame_4->hide();
    ui.frame_6->hide();
    ui.frame_7->show();
    ui.frame_8->hide();
}
