# Search engine object

from Error import *

import ConfigParser
import osso
import shutil
   
class Engine:

   #-----------------------------------------------------------------
   #  Sets up the class
   #-----------------------------------------------------------------
   
   def __init__(self, engine_name):
      self.ENGINE_DIR = "/opt/touchsearch/search_engines/"
      
      # Required services
      self.osso_context = osso.Context("org.touchsearch.touchsearch", "3.0", False)
      self.osso_rpc = osso.Rpc(self.osso_context)
      
      # Load all the required info
      try:
         user_config_file = open(self.ENGINE_DIR + engine_name + "/" + engine_name + ".search", 'r')
         user_config_access = ConfigParser.RawConfigParser()
         user_config_access.readfp(user_config_file)
         
         self.name = user_config_access.get('DEFAULT', 'name')
         self.url_without_sub = user_config_access.get('DEFAULT', 'url')
         self.prefix = user_config_access.get('DEFAULT', 'prefix')
         self.category = user_config_access.get('DEFAULT', 'category')
         self.list_icon = user_config_access.get('DEFAULT', 'list_icon')
         self.languages = user_config_access.get('DEFAULT', 'languages')
         self.language = user_config_access.get('DEFAULT', 'language')
         
         # Icon processing
         try:
            self.color_icon_name = user_config_access.get('DEFAULT', 'color_icon')
            self.color_icon = (self.ENGINE_DIR + self.name + "/" + self.color_icon_name)
         except Exception:
            self.color_icon_name = user_config_access.get('DEFAULT', 'icon')
            self.color_icon = (self.ENGINE_DIR + self.name + "/" + self.color_icon_name)
         try:
            self.ghosted_icon_name = user_config_access.get('DEFAULT', 'ghosted_icon')
            if not self.ghosted_icon_name == None:
               self.ghosted_icon = (self.ENGINE_DIR + self.name + "/" + self.ghosted_icon_name)
            else:
               self.ghosted_icon = None
         except Exception:
            self.ghosted_icon = None
         
         # Process data
         self.languages = self.languages.split(",")
         self.languages.sort()
         self.url = self.url_without_sub % {"lang":self.language, "query":"%s"}

         user_config_file.close()
      except Exception, e:
         # Settings file doesn't have the required option or doesn't exist
         error()

   #-----------------------------------------------------------------
   #  Opens the browser and searches the web, given the user's query
   #-----------------------------------------------------------------

   def search(self, query):
      url_scheme = self.url_without_sub % {"lang":self.language, "query":query}
      self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", (url_scheme,))

   #-----------------------------------------------------------------
   #  What we want to show when the object is in a string
   #-----------------------------------------------------------------

   def __str__(self):
      return self.name

   #-----------------------------------------------------------------
   #  Returns the current engines name
   #-----------------------------------------------------------------
      
   def get_name(self):
      return self.name

   #-----------------------------------------------------------------
   #  Returns the current engines prefix
   #-----------------------------------------------------------------
      
   def get_prefix(self):
      return self.prefix

   #-----------------------------------------------------------------
   #  Returns the current engines language
   #-----------------------------------------------------------------

   def get_language(self):
      return self.language

   #-----------------------------------------------------------------
   #  Returns the current engines language
   #-----------------------------------------------------------------

   def get_languages(self):
      return self.languages

   #-----------------------------------------------------------------
   #  Returns the current engines color icon
   #-----------------------------------------------------------------

   def get_color_icon(self):
      return self.color_icon

   #-----------------------------------------------------------------
   #  Returns the current engines ghosted icon
   #-----------------------------------------------------------------

   def get_ghosted_icon(self):
      if not self.ghosted_icon == None:
         return self.ghosted_icon
      else:
         return self.color_icon

   #-----------------------------------------------------------------
   #  Returns the current engines list icon
   #-----------------------------------------------------------------
      
   def get_list_icon(self):
      return self.list_icon

   #-----------------------------------------------------------------
   #  Returns the current engines category
   #-----------------------------------------------------------------

   def get_category(self):
      return self.category

   #-----------------------------------------------------------------
   #  Sets the prefix
   #-----------------------------------------------------------------

   def set_prefix(self, prefix):
      self.prefix = prefix

   #-----------------------------------------------------------------
   #  Sets the category
   #-----------------------------------------------------------------

   def set_category(self, category):
      self.category = category

   #-----------------------------------------------------------------
   #  Sets the url (without sub)
   #-----------------------------------------------------------------

   def set_url(self, url):
      self.url_without_sub = url

   #-----------------------------------------------------------------
   #  Sets the language
   #-----------------------------------------------------------------

   def set_language(self, language):
      self.language = language
      self.url = self.url_without_sub % {'lang':language, 'query':'%s'}

   #-----------------------------------------------------------------
   #  Writes the actual data
   #-----------------------------------------------------------------
      
   def write(self):
      user_config_file = open(self.ENGINE_DIR + self.name + "/" + self.name + ".search", 'w')
      user_config_access = ConfigParser.RawConfigParser()
      
      languages = ""
      for lang in self.languages: languages += (lang + ',')
      languages = languages[:-1]
      
      # These values cannot be changed, and are set to what they already are
      user_config_access.set('DEFAULT', 'name', self.name)
      user_config_access.set('DEFAULT', 'url', self.url_without_sub)
      user_config_access.set('DEFAULT', 'category', self.category)
      user_config_access.set('DEFAULT', 'color_icon', self.color_icon_name)
      user_config_access.set('DEFAULT', 'ghosted_icon', self.ghosted_icon_name)
      user_config_access.set('DEFAULT', 'list_icon', self.list_icon)
      user_config_access.set('DEFAULT', 'languages', languages)
      user_config_access.set('DEFAULT', 'prefix', self.prefix)
      user_config_access.set('DEFAULT', 'language', self.language)
      
      user_config_access.write(user_config_file)
      user_config_file.close()

   #-----------------------------------------------------------------
   #  Removes this search engine from the device
   #-----------------------------------------------------------------
      
   def delete(self):
      shutil.rmtree(self.ENGINE_DIR + self.name + "/")
      