import gobject
import gtk
import hildondesktop
import hildon
import os
import cairo
import ConfigParser
import subprocess
import osso
import cPickle
import string
import pango
import sys

sys.path.insert(0, "/opt/touchsearch/lib/")

from Engine import *
from Settings import *
from Dialogs import *

HOME = os.getenv('HOME')

ts_dir = '%s/.touchsearch/' % HOME
if not os.path.exists(ts_dir):
   os.mkdir(ts_dir)
   
se_file = '%s/.touchsearch/search_engines.dat' % HOME
if not os.path.exists(se_file):
   default = ['Google', 'QuickBar', 'Amazon', 'Wikipedia', 'Dictionary', 'GoogleMapsMobile', 'Ebay', 'YouTube']
   data = open(se_file, 'w')
   cPickle.dump(default, data)
   data.close()
   

class TouchSearch(hildondesktop.HomePluginItem):
   engine = None
   settings = None

   def __init__(self):
      hildondesktop.HomePluginItem.__init__(self)
      
      # Connect to the settings interface
      self.set_settings(True)
      self.connect("show-settings", self.options_dialog)

      self.hbox = gtk.HBox()
      self.vbox = gtk.VBox()
      self.search_eventbox = gtk.EventBox()
      self.search_eventbox.set_size_request(136, 54)
      self.select_eventbox = gtk.EventBox()
      self.select_eventbox.set_size_request(40, 54)
      
      self.update_info()
      
      self.hbox.pack_start(self.search_eventbox, False, False, 10)
      self.hbox.pack_end(self.select_eventbox, False, False, 10)
      self.vbox.pack_start(self.hbox, False, False, 10)
      self.vbox.show_all()
      self.add(self.vbox)
      
      self.search_eventbox.set_events(gtk.gdk.BUTTON_RELEASE_MASK)
      self.search_dialog = self.search_eventbox.connect("button-release-event", self.SearchDialog)
      self.select_eventbox.set_events(gtk.gdk.BUTTON_RELEASE_MASK)
      self.selection = self.select_eventbox.connect("button-release-event", self.SelectDialog, self)

   def update_info(self, widget=None):
      TouchSearch.settings = Settings()
      TouchSearch.engine = Engine(TouchSearch.settings.get_search_engine())
      
   def do_expose_event(self, event):
      cr = self.window.cairo_create()
      cr.set_source_rgba(1.0, 1.0, 1.0, 0.0) # Transparent

      # Draw the background
      cr.set_operator(cairo.OPERATOR_SOURCE)
      cr.paint()
      
      # Paint icons for both eventboxes's
      self.draw_e()
      self.draw_s()

      # draw rounded rect
      width, height = self.allocation[2], self.allocation[3]
      
      x0 = 0
      y0 = 0
      
      radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */
      
      x1 = x0 + width
      y1 = y0 + height
      
      cr.move_to  (x0, y0 + radius)
      cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
      cr.line_to (x1 - radius, y0)
      cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
      cr.line_to (x1 , y1 - radius)
      cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
      cr.line_to (x0 + radius, y1)
      cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)
      
      cr.close_path ()

      cr.set_source_rgba (0.0, 0.0, 0.0, TouchSearch.settings.get_opacity())
      cr.fill_preserve ()
      return False

   def do_realize(self):
      screen = self.get_screen()
      colormap = screen.get_rgba_colormap()
      self.set_colormap(colormap)
      hildondesktop.HomePluginItem.do_realize(self)
      
   def draw_e(self):
      cr_e = self.select_eventbox.window.cairo_create()
      cr_e.set_source_rgba(0.0, 0.0, 0.0, TouchSearch.settings.get_opacity()) # Transparent
      cr_e.set_operator(cairo.OPERATOR_SOURCE)
      cr_e.paint()
      
      cr_e.set_operator(cairo.OPERATOR_OVER)
      if TouchSearch.settings.get_icon_style() == "Ghosted":
         path = "/opt/touchsearch/icons/select_search_engine_ghosted.png"
      else:
         path = "/opt/touchsearch/icons/select_search_engine_color.png"
      image = cairo.ImageSurface.create_from_png(path)
      cr_e.set_source_surface(image, 0, 7)
      cr_e.paint()
      
   def draw_s(self):
      cr_s = self.search_eventbox.window.cairo_create()
      cr_s.set_source_rgba(0.0, 0.0, 0.0, TouchSearch.settings.get_opacity()) # Transparent
      cr_s.set_operator(cairo.OPERATOR_SOURCE)
      cr_s.paint()
      
      if TouchSearch.settings.get_icon_style() == "Ghosted":
         image = cairo.ImageSurface.create_from_png(TouchSearch.engine.get_ghosted_icon())
      else:
         image = cairo.ImageSurface.create_from_png(TouchSearch.engine.get_color_icon())
      
      cr_s.set_operator(cairo.OPERATOR_OVER)
      cr_s.set_source_surface(image, 10, 9)
      cr_s.paint()
      
   def options_dialog(self, event):
      MainOptionsDialog(event)
      print TouchSearch.settings.get_search_engine()
      self.update_info()
      self.do_expose_event(None)
      
   #-----------------------------------------------------------------
   #  SearchDialog class
   #-----------------------------------------------------------------

   class SearchDialog(gtk.Dialog):

      #-----------------------------------------------------------------
      #  Sets up the search dialog class
      #-----------------------------------------------------------------
      
      def __init__(self, widget, event):
         gtk.Dialog.__init__(self, "Search:", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
         button = self.add_button("Search", 1)
         
         if TouchSearch.settings.get_show_corefour():
            corefour = TouchSearch.settings.get_corefour()
            notebook = gtk.Notebook()
            print corefour
            displayed_engines = []
            
            if TouchSearch.settings.get_icon_style() == "Ghosted":
               icon = TouchSearch.engine.get_ghosted_icon()
            else:
               icon = TouchSearch.engine.get_color_icon()
            icon = gtk.gdk.pixbuf_new_from_file_at_size(icon, 122, 40)
            image = gtk.Image()
            image.set_from_pixbuf(icon)
            notebook.append_page(gtk.HBox(), image)
            
            for engine_name in corefour:
               if not engine_name == TouchSearch.engine.get_name():
                  displayed_engines.append(engine_name)
                  engine = Engine(engine_name)
                  if TouchSearch.settings.get_icon_style() == "Ghosted":
                     icon = engine.get_ghosted_icon()
                  else:
                     icon = engine.get_color_icon()
                  icon = gtk.gdk.pixbuf_new_from_file_at_size(icon, 122, 40)
                  image = gtk.Image()
                  image.set_from_pixbuf(icon)
                  notebook.append_page(gtk.HBox(), image)
            
            entry = hildon.Entry(0)
            self.vbox.pack_start(notebook)
            self.vbox.pack_start(entry, True, True, 0)
            notebook.connect("switch-page", self.page_switched, entry)
            button.connect('clicked', self.search_the_web, entry, notebook, displayed_engines)
            entry.connect("key-press-event", self.key_pressed, entry, notebook, displayed_engines)
            
         else:
            engine = TouchSearch.engine
            if TouchSearch.settings.get_icon_style() == "Ghosted":
               icon = engine.get_ghosted_icon()
            else:
               icon = engine.get_color_icon()
            icon = gtk.gdk.pixbuf_new_from_file_at_size(icon, 122, 40)
            image = gtk.Image()
            image.set_from_pixbuf(icon)
            evbox = gtk.EventBox()
            evbox.add(image)
            #evbox.set_events(gtk.gdk.BUTTON_RELEASE_MASK)
            #evbox.connect("button-release-event", self.select_engine_dialog, dialog)
            entry = hildon.Entry(0)

            hbox = gtk.HBox()
            hbox.pack_start(evbox, False, False, 5)
            hbox.pack_end(entry, True, True, 5)
            
            self.vbox.pack_start(hbox)
            button.connect('clicked', self.search_the_web, entry, TouchSearch.engine)
            entry.connect("key-press-event", self.key_pressed, entry)
         
         entry.grab_focus()
         self.show_all()
         self.run()
         self.destroy()
         

      #-----------------------------------------------------------------
      #  Calls the search method of the engine class
      #-----------------------------------------------------------------

      def search_the_web(self, widget, entry, notebook=None, displayed_engines=None):
         if (notebook != None and displayed_engines != None):
            page = notebook.get_current_page()
            
            if page == 0:
               engine = TouchSearch.engine
            else:
               engine_name = displayed_engines[page-1]
               engine = Engine(engine_name)
            
         else:
            engine = TouchSearch.engine
            
         query = entry.get_text()
         if engine.get_name() == 'QuickBar':
            prefix = query.split(" ")[0]
            actual_query = query[len(prefix)+1:]
            engine = None
            ie = InstalledEngines()
            search_engines = ie.read()
            for e in search_engines:
               eng = Engine(e)
               if eng.get_prefix().lower() == prefix.lower():
                  engine = eng
            if engine == None:
               engine = Engine('Google')
               actual_query = query
            engine.search(actual_query)
         else:
            engine.search(query)

      #-----------------------------------------------------------------
      #  Listens for Enter/Return key on the keyboard
      #-----------------------------------------------------------------
         
      def key_pressed(self, widget, event, entry, notebook=None, displayed_engines=None, *args):
         if event.keyval == gtk.keysyms.KP_Enter or event.keyval == gtk.keysyms.Return:
            self.search_the_web(widget, entry, notebook, displayed_engines)
            self.destroy()
         else:
            return False
            
      def page_switched(self, widget, page, page_num, entry):
         gobject.idle_add(entry.grab_focus)
         return False
            
   #-----------------------------------------------------------------
   #  SelectDialog class
   #-----------------------------------------------------------------
   
   class SelectDialog(hildon.PickerDialog):
      
      #-----------------------------------------------------------------
      #  Sets up the search dialog class
      #-----------------------------------------------------------------
      
      def __init__(self, widget, event, parent):
         hildon.PickerDialog.__init__(self, gtk.Window())
         self.set_title("Select Search Engine")
         
         selector = hildon.TouchSelector(text=True)
         engines_obj = InstalledEngines()
         self.search_engines = engines_obj.read()
         for engine in self.search_engines:
            selector.append_text(engine)
         selector.connect("changed", self.selector_changed, parent)
         self.set_selector(selector)
         self.run()
         self.destroy()
         
      #-----------------------------------------------------------------
      #  Listens for changes in the TouchSelector
      #-----------------------------------------------------------------
         
      def selector_changed(self, widget, data, parent):
         selection = widget.get_current_text()
         # Setup the engine
         TouchSearch.settings.set_search_engine(selection)
         TouchSearch.settings.write()
         TouchSearch.engine = Engine(selection)
         # Call the parent class paint methods
         TouchSearch.do_expose_event(parent, widget)


hd_plugin_type = TouchSearch

if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()