import gtk
import hildon
from Settings import *
import osso
from Engine import *
import gobject

class MainOptionsDialog(gtk.Dialog):
   def __init__(self, widget):
      gtk.Dialog.__init__(self, "TouchSearch Options", None)
      
      self.osso_context = osso.Context("org.touchsearch.touchsearch", "3.0", False)
      self.osso_rpc = osso.Rpc(self.osso_context)
      
      main_vbox = gtk.VBox()
      pa = hildon.PannableArea()
      
      more_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      more_button.set_text("Add new search engines", "Download or make your own search engines")
      more_button.set_alignment(0,0,0,0)
      more_button.connect('clicked', self.show_more)
      
      help_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      help_button.set_text("Help", "Get help with how to use TouchSearch")
      help_button.set_alignment(0,0,0,0)
      help_button.connect('clicked', self.show_help)
      
      settings_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      settings_button.set_text("Settings", "Change how TouchSearch works")
      settings_button.set_alignment(0,0,0,0)
      settings_button.connect('clicked', SettingsDialog)
      
      configure_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      configure_button.set_text("Configure", "Customize your search experience")
      configure_button.set_alignment(0,0,0,0)
      configure_button.connect('clicked', ConfigureDialog)
      
      donate_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      donate_button.set_text("Donate", "Support TouchSearch by donating any amount of your choosing")
      donate_button.set_alignment(0,0,0,0)
      donate_button.connect("clicked", self.show_donate)
      
      about_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      about_button.set_text("About", "See Author, Copyright and License information")
      about_button.set_alignment(0,0,0,0)
      about_button.connect("clicked", AboutDialog)
      
      main_vbox.pack_start(more_button, True, True, 0)
      main_vbox.pack_start(help_button, True, True, 0)
      main_vbox.pack_start(settings_button, True, True, 0)
      main_vbox.pack_start(configure_button, True, True, 0)
      main_vbox.pack_start(donate_button, True, True, 0)
      main_vbox.pack_start(about_button, True, True, 0)
      
      pa.add_with_viewport(main_vbox)
      pa.set_size_request(-1, 350)
      self.vbox.pack_start(pa, True, True, 0)
      
      self.show_all()
      self.run()
      self.destroy()
      
   def show_more(self, widget):
      dialog = gtk.Dialog("Add engines", None)
      
      download_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      download_button.set_text("Get search engines", "Download search engines from TouchSearch.org")
      download_button.set_alignment(0,0,0,0)
      download_button.connect('clicked', self.show_download)
      
      create_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      create_button.set_text("Create engine", "Make your own search engine")
      create_button.set_alignment(0,0,0,0)
      create_button.connect('clicked', CreateEngine)
      
      dialog.vbox.pack_start(download_button, True, True, 0)
      dialog.vbox.pack_start(create_button, True, True, 0)
      
      dialog.show_all()
      dialog.run()
      dialog.destroy()
      
      
   def show_download(self, widget):
      self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", ("http://www.touchsearch.org/addons/",))
   
   def show_help(self, widget):
      self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", ("http://www.touchsearch.org/help/",))
      
   def show_donate(self, widget):
      self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", ("http://www.touchsearch.org/donate/",))
      

class CreateEngine(gtk.Dialog):
   def __init__(self, widget):
      gtk.Dialog.__init__(self, "Create engine", None)
      ok_button = self.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      
      self.osso_context = osso.Context("org.touchsearch.touchsearch", "3.0", False)
      self.osso_rpc = osso.Rpc(self.osso_context)
      
      main_vbox = gtk.VBox()
      pa = hildon.PannableArea()
      
      help_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      help_button.set_text("View online instructions (this will exit this dialog)", "")
      #help_button.set_alignment(0,0,0,0)
      help_button.connect('clicked', self.show_help)
      
      name_hbox = gtk.HBox()
      name_entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
      name_hbox.pack_start(gtk.Label("Name:"), False, False, 5)
      name_hbox.pack_start(name_entry, True, True, 5)
      
      category_hbox = gtk.HBox()
      category_entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
      category_hbox.pack_start(gtk.Label("Category:"), False, False, 5)
      category_hbox.pack_start(category_entry, True, True, 5)
      
      url_hbox = gtk.HBox()
      url_entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
      url_hbox.pack_start(gtk.Label("URL:"), False, False, 5)
      url_hbox.pack_start(url_entry, True, True, 5)
      
      prefix_hbox = gtk.HBox()
      prefix_entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
      prefix_entry.set_max_length(4)
      prefix_hbox.pack_start(gtk.Label("QuickBar Prefix:"), False, False, 5)
      prefix_hbox.pack_start(prefix_entry, True, True, 5)
      
      default_icon_button = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
      default_icon_button.set_label("Create icon automatically")
      default_icon_button.set_active(True)

      white_button = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, None)
      white_button.set_label("White")
      white_button.set_mode(False)
      black_button = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, white_button)
      black_button.set_label("Black")
      black_button.set_mode(False)
      grey_button = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, white_button)
      grey_button.set_label("Grey")
      grey_button.set_mode(False)
      
      color_hbox = gtk.HBox()
      color_hbox.pack_start(white_button, True, True, 0)
      color_hbox.pack_start(black_button, True, True, 0)
      color_hbox.pack_start(grey_button, True, True, 0)
      
      custom_icon_button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      custom_icon_button.set_label("Select custom icon")
      custom_icon_button.set_sensitive(False)
      
      default_icon_button.connect("toggled", self.toggled, custom_icon_button, color_hbox)
      custom_icon_button.connect("clicked", self.open_file)
      ok_button.connect("clicked", self.ok_callback, name_entry, category_entry, url_entry, prefix_entry, default_icon_button, custom_icon_button, white_button, black_button, grey_button)
      
      main_vbox.pack_start(help_button, True, True, 10)
      main_vbox.pack_start(name_hbox, True, True, 10)
      main_vbox.pack_start(category_hbox, True, True, 10)
      main_vbox.pack_start(url_hbox, True, True, 10)
      main_vbox.pack_start(prefix_hbox, True, True, 10)
      main_vbox.pack_start(default_icon_button, True, True, 10)
      main_vbox.pack_start(color_hbox, True, True, 10)
      main_vbox.pack_start(custom_icon_button, True, True, 10)
      
      pa.add_with_viewport(main_vbox)
      pa.set_size_request(-1, 400)
      self.vbox.pack_start(pa, True, True, 0)
      self.show_all()
      self.run()
      self.destroy()
         
   def ok_callback(self, widget, name_entry, category_entry, url_entry, prefix_entry, default_icon_button, custom_icon_button, white_button, black_button, grey_button):
      
      name = name_entry.get_text()
      category = category_entry.get_text()
      url = url_entry.get_text()
      prefix = prefix_entry.get_text()
      use_default_icon = default_icon_button.get_active()
      custom_icon = custom_icon_button.get_value()
      if black_button.get_active():
         color = (0.0, 0.0, 0.0)
      elif grey_button.get_active():
         color = (0.7, 0.7, 0.7)
      else:
         color = (1.0, 1.0, 1.0)
      
      retcode, error = AddEngine().add(name, category, url, prefix, use_default_icon, custom_icon, color)
      if retcode == 0: message_type = gtk.MESSAGE_INFO
      else: message_type = gtk.MESSAGE_ERROR
      dialog = gtk.MessageDialog(None, 0, message_type, gtk.BUTTONS_NONE, error)
      dialog.run()
      dialog.destroy()
      
      print retcode
      print error
      print name
      print category
      print url
      print prefix
      print use_default_icon
      print custom_icon
      print color
      
   def open_file(self, widget):
      fc = gobject.new(hildon.FileChooserDialog, action=gtk.FILE_CHOOSER_ACTION_OPEN)
      fc.set_property('show-files', True)
      if fc.run() == gtk.RESPONSE_OK:
        filepath = fc.get_filename()
        widget.set_value(filepath)
      fc.destroy()
      
   def toggled(self, widget, button, hbox):
      if widget.get_active():
         button.set_sensitive(False)
         hbox.set_sensitive(True)
      else:
         button.set_sensitive(True)
         hbox.set_sensitive(False)
   
   def show_help(self, widget):
      self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", ("http://www.touchsearch.org/help/adding-custom-search-engines/",))
      

class SettingsDialog(gtk.Dialog):
   def __init__(self, widget):
      gtk.Dialog.__init__(self, "Settings", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
      search_button = self.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      settings = Settings()
      
      main_vbox = gtk.VBox()
      
      scale = hildon.GtkHScale()
      scale.set_draw_value(False)
      adjustment = scale.get_adjustment()
      adjustment.set_property("step-increment", 0.01)
      adjustment.set_property("lower", 0.0)
      adjustment.set_property("upper", 1.0)
      adjustment.set_property("value", settings.get_opacity())
      
      picker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
      selector = hildon.TouchSelector(text=True)
      selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_MULTIPLE)
      ie = InstalledEngines()
      for engine in ie.read():
         selector.append_text(engine)
      picker.set_selector(selector)
      text = ""
      for s in settings.get_corefour():
         text += "%s%s" % (s, ",")
      picker.set_value("%s%s%s" % ("(", text[0:-1], ")"))

      standard_button = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, None)
      standard_button.set_label("Standard")
      standard_button.set_mode(False)
      enhanced_button = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, standard_button)
      enhanced_button.set_label("Enhanced")
      enhanced_button.set_mode(False)

      color_button = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, None)
      color_button.set_label("Color")
      color_button.set_mode(False)
      ghosted_button = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT, color_button)
      ghosted_button.set_label("Ghosted")
      ghosted_button.set_mode(False)
      
      if settings.get_show_corefour():
         enhanced_button.set_active(True)
      else:
         standard_button.set_active(True)
         
      if settings.get_icon_style() == "Ghosted":
         ghosted_button.set_active(True)
      else:
         color_button.set_active(True)
      
      ui_hbox = gtk.HBox()
      ui_hbox.pack_start(standard_button, True, True, 0)
      ui_hbox.pack_end(enhanced_button, True, True, 0)
      
      icon_hbox = gtk.HBox()
      icon_hbox.pack_start(color_button, True, True, 0)
      icon_hbox.pack_end(ghosted_button, True, True, 0)
      
      main_vbox.pack_start(gtk.Label("Widget Opacity"), False, False, 0)
      main_vbox.pack_start(scale, False, False, 10)
      main_vbox.pack_start(gtk.HSeparator())
      main_vbox.pack_start(gtk.Label("Favorites"), False, False, 0)
      main_vbox.pack_start(picker, True, True, 10)
      main_vbox.pack_start(gtk.HSeparator())
      main_vbox.pack_start(gtk.Label("Search Dialog"), False, False, 0)
      main_vbox.pack_start(ui_hbox, True, True, 10)
      main_vbox.pack_start(gtk.Label("Icon Style"), False, False, 0)
      main_vbox.pack_start(icon_hbox, True, True, 10)
      
      pa = hildon.PannableArea()
      pa.add_with_viewport(main_vbox)
      pa.set_size_request(-1, 400)
      
      self.vbox.pack_start(pa, True, True, 0)
      self.show_all()
      response = self.run()
      
      if response == gtk.RESPONSE_OK:
         pos = scale.get_value()
         corefour = picker.get_value()[1:-1].split(",")
         print "Corefour test: %s" % corefour
         if standard_button.get_active() == True:
            show_corefour = 0
         else:
            show_corefour = 1
         if ghosted_button.get_active() == True:
            icon_style = "Ghosted"
         else:
            icon_style = "Color"
         settings.set_show_corefour(show_corefour)
         settings.set_corefour(corefour)
         settings.set_opacity(pos)
         settings.set_icon_style(icon_style)
         settings.write()

      self.destroy()
      
      
class ConfigureDialog(gtk.Dialog):
   def __init__(self, widget):
      gtk.Dialog.__init__(self, "Configure Search Engines", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
      main_vbox = ConfigureVbox()
      self.vbox.pack_start(main_vbox)
      self.show_all()
      self.run()
      
      # Save all the changes
      engines = [ r[0] for r in main_vbox.liststore ]
      ie = InstalledEngines()
      ie.write(engines)
      self.destroy()

      
class ConfigureVbox(gtk.VBox):
   def __init__(self):
      gtk.VBox.__init__(self)
      settings = Settings()
      settings.set_search_engine('Google')
      settings.write()
      ie = InstalledEngines()
      self.search_engines = ie.read()
      
      self.liststore = gtk.ListStore(str)
      for s in self.search_engines:
         self.liststore.append([s])

      self.treeview = hildon.GtkTreeView(gtk.HILDON_UI_MODE_EDIT)
      self.treeview.set_model(self.liststore)
      self.treeview.set_reorderable(True)
      
      self.tvcolumn = gtk.TreeViewColumn('Column 0')
      self.treeview.append_column(self.tvcolumn)
      cell = gtk.CellRendererText()
      self.tvcolumn.pack_start(cell, True)
      self.tvcolumn.add_attribute(cell, 'text', 0)
      
      self.ts = hildon.PannableArea()
      self.ts.set_size_request(-1, 280)
      self.ts.add(self.treeview)
      
      hbox = gtk.HBox()
      edit_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
      edit_button.set_label("Edit")
      edit_button.connect('clicked', self.edit_callback)
      delete_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
      delete_button.set_label("Delete")
      delete_button.connect('clicked', self.delete_callback)
      up_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
      up_button.set_label("Up")
      up_button.connect('clicked', self.up_callback)
      down_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
      down_button.set_label("Down")
      down_button.connect('clicked', self.down_callback)
      
      hbox.pack_start(edit_button, True, True, 0)
      hbox.pack_start(delete_button, True, True, 0)
      hbox.pack_start(up_button, True, True, 0)
      hbox.pack_start(down_button, True, True, 0)
      
      selection = self.treeview.get_selection()
      selection.connect("changed", self.check_editable, edit_button, delete_button, up_button, down_button)
      self.liststore.connect("rows-reordered", self.check_top_or_bottom, up_button, down_button)
      self.pack_start(self.ts, True, True, 0)
      self.pack_end(hbox, False, False, 0)
      
   def check_top_or_bottom(self, widget, path, iter, new_order, up_button, down_button):
      model, treeiter, path, engine = self.get_treeview_data()
      print model, treeiter, engine, path
      
      if path[0] == 0:
         up_button.set_sensitive(False)
      else:
         up_button.set_sensitive(True)
      if path[0] == len(model) - 1:
         down_button.set_sensitive(False)
      else:
         down_button.set_sensitive(True)
      
   def check_editable(self, widget, edit_button, delete_button, up_button, down_button):
      model, treeiter, path, engine = self.get_treeview_data()
      
      self.check_top_or_bottom(widget, None, None, None, up_button, down_button)
      
      if model[treeiter][0] == "Google":
         delete_button.set_sensitive(False)
         edit_button.set_sensitive(True)
      elif model[treeiter][0] == "QuickBar":
         edit_button.set_sensitive(False)
         delete_button.set_sensitive(True)
      else:
         edit_button.set_sensitive(True)
         delete_button.set_sensitive(True)
      
   def get_treeview_data(self):
      selection = self.treeview.get_selection()
      model, treeiter = selection.get_selected()
      path = self.liststore.get_path(treeiter)
      engine_name = model[treeiter][0]
      engine = Engine(engine_name)
      return (model, treeiter, path, engine)
   
   def up_callback(self, widget):
      model, treeiter, path, engine = self.get_treeview_data()
      
      if treeiter is not None:
         a_row = path[0]
         b_row = a_row - 1
         a = treeiter
         b = self.liststore.get_iter(b_row)
         self.liststore.swap(a, b)
      self.scroll()
      
   def down_callback(self, widget):
      model, treeiter, path, engine = self.get_treeview_data()
      path = self.liststore.get_path(treeiter)
      
      if treeiter is not None:
         a_row = path[0]
         b_row = a_row + 1
         a = treeiter
         b = self.liststore.get_iter(b_row)
         self.liststore.swap(a, b)
      self.scroll()
      
   def scroll(self):
      model, treeiter, path, engine = self.get_treeview_data()
      rect = self.treeview.get_background_area(path, self.tvcolumn)
      x, y = self.treeview.convert_bin_window_to_tree_coords(0, rect.y)
      self.ts.scroll_to(-1, y)
   
   def delete_callback(self, widget):
      model, treeiter, path, engine = self.get_treeview_data()
      note = hildon.Note("confirmation", gtk.Window(), "Are you sure you want to delete '%s'?" % engine)
      response = gtk.Dialog.run(note)
      if response == gtk.RESPONSE_OK:
         model.remove(treeiter)
         engine.delete()
      note.destroy()
   
   def edit_callback(self, widget):
      dialog = gtk.Dialog("Edit Search Engine", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
      ok = dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      model, treeiter, path, engine = self.get_treeview_data()
      
      name_label = gtk.Label("Name: %s" % engine.get_name())
      name_label.set_alignment(0.0, 0.0)
      
      prefix_entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
      prefix_entry.set_text(engine.get_prefix())
      prefix_entry.set_max_length(4)
      
      category_hbox = gtk.HBox()
      category_entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
      category_entry.set_text(engine.get_category())
      category_hbox.pack_start(gtk.Label("Category:"), False, False, 0)
      category_hbox.pack_start(category_entry, True, True, 10)
      
      prefix_hbox = gtk.HBox()
      prefix_hbox.pack_start(gtk.Label("QuickBar Prefix:"), False, False, 0)
      prefix_hbox.pack_end(prefix_entry, True, True, 10)
      
      language_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
      language_button.set_text("Localization/Language:", engine.get_language())
      selector = hildon.TouchSelector(text=True)
      languages = engine.get_languages()
      language = engine.get_language()
      for lang in languages: selector.append_text(lang)
      index = languages.index(language)
      selector.set_active(0, index)
      language_button.set_selector(selector)
      language_button.set_value(language)
      
      dialog.vbox.pack_start(name_label, True, True, 10)
      dialog.vbox.pack_start(category_hbox, True, True, 5)
      dialog.vbox.pack_start(prefix_hbox, True, True, 5)
      dialog.vbox.pack_start(language_button, True, True, 5)
      
      dialog.show_all()
      response = dialog.run()
      
      if response == gtk.RESPONSE_OK:
         prefix = prefix_entry.get_text()
         category = category_entry.get_text()
         language = language_button.get_value()
         engine.set_prefix(prefix)
         engine.set_category(category)
         engine.set_language(language)
         engine.write()
         
      dialog.destroy()


class AboutDialog(gtk.AboutDialog):
   def __init__(self, widget):
      gtk.AboutDialog.__init__(self)
      self.set_title("About")
      self.set_name("TouchSearch")
      self.set_version("3.1")
      self.set_copyright("Copyright 2009, 2010 Brent Chiodo")
      self.set_authors(["Brent Chiodo <bchiodo@gmail.com>"])
      self.set_logo(gtk.gdk.pixbuf_new_from_file("/opt/touchsearch/icons/icon.png"))
      self.set_comments("All logos and trademarks are property of their respective owners and are used for informational purposes only.")
      self.set_license("""This program is free software: you can redistribute it and/or
modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public 
License along with this program.  If not, see
<http://www.gnu.org/licenses/>.""")
      self.set_wrap_license(True)
      self.show_all()
      self.run()
      self.destroy()