#!/usr/bin/env python

from distutils.core import setup
import os

ghosted_icons = []
color_icons = []

for f in os.listdir("icons/color/"):
   ghosted_icons.append("icons/ghosted/" + f)
   color_icons.append("icons/color/" + f)

setup(name='touchsearch',
   version='1.3',
   data_files = [
      ('/usr/lib/hildon-desktop/',['touchsearch.py']),
      ('/usr/share/applications/hildon-home/',['touchsearch.desktop']),
      ('/usr/share/touchsearch/ghosted/', ghosted_icons),
      ('/usr/share/touchsearch/color/', color_icons),
      ('/usr/share/touchsearch/', ['icons/select_search_engine_ghosted.png',
      'icons/select_search_engine_color.png', 'icons/icon.png'])
      ]
      )