import gobject
import gtk
import hildondesktop
import hildon
import os
import ConfigParser
import subprocess

HOME = os.getenv('HOME')

if not os.path.exists(HOME + "/.touchsearch/"):
   dir = '%s/.touchsearch/' % HOME
   os.mkdir(dir)

class TouchSearchHomePlugin(hildondesktop.HomePluginItem):
   __gtype_name__ = 'TouchSearchHomePlugin'

   def __init__(self):
      hildondesktop.HomePluginItem.__init__(self)

      settings = self.get_settings()
      image, url = self.get_data(settings['search_engine'])

      self.hbox = gtk.HBox()

      self.search_button = gtk.Button()
      self.search_button.set_image(image)
      self.search_button.connect("clicked", self.search_dialog)
      self.search_button.show_all()

      self.select_button = gtk.Button()
      self.select_icon = gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/touchsearch/select_search_engine.png", 40, 40)
      self.select_image = gtk.Image()
      self.select_image.set_from_pixbuf(self.select_icon)
      self.select_image.set_padding(settings['padding'], settings['padding'])
      self.select_button.set_image(self.select_image)
      self.select_button.connect("clicked", self.select_engine_dialog)
      #selector = hildon.TouchSelector(text=True)
      #searches = ["Google", "eBay", "General Shopping", "Dictionary.com", "Google Maps"]
      #for i in searches:
      #   selector.append_text(i)
      #self.select_button.set_selector(selector)
      #self.select_button.connect("value-changed", self.on_picker_value_changed)

      self.select_button.show_all()

      self.hbox.pack_start(self.search_button)
      self.hbox.pack_end(self.select_button)
      self.hbox.show_all()

      self.add(self.hbox)
      
   def on_picker_value_changed(self, widget, data):
      engine = widget.get_current_text()
      image, url = self.get_data(engine)
      self.search_button.set_image(image)
      self.set_settings(widget, engine)

   def search_dialog(self, widget):
      settings = self.get_settings()
      dialog = gtk.Dialog("Type A Search Query", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
      search_button = dialog.add_button("Search", 1)

      image, url = self.get_data(settings['search_engine'])
      entry = gtk.Entry()

      hbox = gtk.HBox()
      hbox.pack_start(image, False, False, 5)
      hbox.pack_end(entry, True, True, 5)
      
      search_button.connect('clicked', self.search_the_web, entry, url)
      dialog.vbox.pack_start(hbox)
      dialog.show_all()
      dialog.run()

      dialog.destroy()
      
   def select_engine_dialog(self, widget):
      dialog = hildon.PickerDialog(gtk.Window())
      dialog.set_title("Select A Site To Search")
      
      selector = hildon.TouchSelector(text=True)
      searches = ["Google", "eBay", "General Shopping", "Dictionary.com", "Google Maps"]
      for i in searches:
         selector.append_text(i)
      selector.connect("changed", self.on_picker_value_changed)
      
      dialog.set_selector(selector)
      dialog.show_all()
      response = dialog.run()
      dialog.destroy()
      
   def search_the_web(self, widget, entry, url):
      query = entry.get_text()
      url_scheme = url % query
      print url_scheme
      call = 'dbus-send --system --type=method_call --dest="com.nokia.osso_browser" --print-reply /com/nokia/osso_browser/request com.nokia.osso_browser.load_url string:"%s"' % url_scheme
      subprocess.Popen(call, shell=True)

   def get_data(self, engine):
      settings = self.get_settings()
      d = settings['icon_style']
      if engine == "Google":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "google.png", 122, 40)
         url = "http://www.google.com/custom?hl=en&client=pub-2014082016242195&channel=8876981054&cof=FORID%%3A13%%3BAH%%3Aleft%%3BS%%3Ahttp%%3A%%2F%%2Fwww.google.com%%2Fcse%%3Fcx%%3D003942025946635967052%%253A4eq_cwvmcim%%26ie%%3DUTF-8%%26q%%3D%%26sa%%3DSearch%%3BCX%%3AWeb%%2520%%2528mobile-optimized%%2529%%3BL%%3Ahttp%%3A%%2F%%2Fwww.google.com%%2Fimages%%2Fgoogle_sm.gif%%3BLH%%3A59%%3BLP%%3A1%%3BVLC%%3A%%23551a8b%%3BGFNT%%3A%%23666666%%3BDIV%%3A%%23cccccc%%3B&adkw=AELymgXvPYDM4X5-BVw_BuVC9v6xuBytBCsp1DhSSByJlGcS0stpcK38sTNjYyfwouQDi7IW3HBDDErXgreOqmYQtxp2DU96bhRZ5Nyjxv8CHhWCKzlYWUc&btnG=Search&cx=partner-pub-2014082016242195&q=%s"
      elif engine == "eBay":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "ebay.png", 122, 40)
         url = "http://shop.ebay.com/?_from=R40&_trksid=p3907.m38.l1313&_nkw=%s&=&_sacat=See-All-Categories"
      elif engine == "General Shopping":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "general_shopping.png", 122, 40)
         url = "http://www.google.com/cse?cx=003942025946635967052%%3Askvgvkrij3u&ie=UTF-8&q=%s&sa=Search"
      elif engine == "Dictionary.com":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "dictionary.png", 122, 40)
         url = "http://m.reference.com/d/search.html?q=%s"
      elif engine == "Google Maps":
         icon = gtk.gdk.pixbuf_new_from_file_at_size(d + "google_maps.png", 122, 40)
         url = "http://maps.google.com/maps?hl=en&tab=wl&q=%s"
      image = gtk.Image()
      image.set_from_pixbuf(icon)
      image.set_padding(settings['padding'], settings['padding'])
      return (image, url)

   def get_settings(self):
      try:
         user_config_file = open(HOME + '/.touchsearch/settings.conf', 'r')
         user_config_access = ConfigParser.RawConfigParser()
         user_config_access.readfp(user_config_file)

         settings_dict = {}
         settings_dict['search_engine'] = user_config_access.get('DEFAULT', 'search_engine')
         settings_dict['icon_style'] = user_config_access.get('DEFAULT', 'icon_style')
         settings_dict['padding'] = int(user_config_access.get('DEFAULT', 'padding'))

         user_config_file.close()
      except Exception, e:
         # Settings file doesn't have the required option or doesn't exist

         print e
         self.set_default_settings(None)
         settings_dict = self.get_settings()

      return settings_dict

   def set_settings(self, widget, search_engine=None, icon_style=None, padding=None):
      settings = self.get_settings()
      user_config_file = open(HOME + '/.touchsearch/settings.conf', 'w')
      user_config_access = ConfigParser.RawConfigParser()

      if search_engine == None:
         user_config_access.set('DEFAULT', 'search_engine', settings['search_engine'])
      else:
         user_config_access.set('DEFAULT', 'search_engine', search_engine)
      if icon_style == None:
         user_config_access.set('DEFAULT', 'icon_style', settings['icon_style'])
      else:
         user_config_access.set('DEFAULT', 'icon_style', icon_style)
      if padding == None:
         user_config_access.set('DEFAULT', 'padding', settings['padding'])
      else:
         user_config_access.set('DEFAULT', 'padding', padding)

      user_config_access.write(user_config_file)
      user_config_file.close()

   def set_default_settings(self, widget, data=None):
      user_config_file = open(HOME + '/.touchsearch/settings.conf', 'w')
      user_config_access = ConfigParser.RawConfigParser()

      user_config_access.set('DEFAULT', 'search_engine', 'Google')
      user_config_access.set('DEFAULT', 'icon_style', '/usr/share/touchsearch/ghosted/')
      user_config_access.set('DEFAULT', 'padding', 5)

      user_config_access.write(user_config_file)
      user_config_file.close()

def hd_plugin_get_object():
   return gobject.new(TouchSearchHomePlugin, plugin_id="touch_search_home")

if __name__ == "__main__":
   obj = hd_plugin_get_object()
   obj.show_all()
   gtk.main()
