<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/1998/REC-html40-19980424/loose.dtd">
<html>
<head>
  <title>Tor : Instructions de configuration d'un relais</title>
  <meta name="Author" content="Roger Dingledine">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet-ltr.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.fr">Accueil</a>
<a href="../overview.html.fr">Vue d'ensemble</a>
<a href="../easy-download.html.fr">Téléchargement</a>
<a href="../documentation.html.fr">Docs</a>
<a href="../volunteer.html.fr">Contribuer</a>
<a href="../people.html.fr">Auteurs</a>
<a href="https://blog.torproject.org/">Blog</a>
<a href="../donate.html.fr">Faites un Don!</a>
        </td>
        <td class="banner-right">
	<a href="tor-doc-relay.html.de"><acronym title="Deutsch"><img src="../images/de.png" alt="Deutsch" width="24" height="16"></acronym></a> <a href="tor-doc-relay.html.en"><acronym title="English"><img src="../images/en.png" alt="English" width="24" height="16"></acronym></a> <a href="tor-doc-relay.html.es"><acronym title="espa&ntilde;ol"><img src="../images/es.png" alt="espa&ntilde;ol" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <acronym title="fran&ccedil;ais"><img src="../images/fr.png" alt="fran&ccedil;ais" width="24" height="16"></acronym> <a href="tor-doc-relay.html.it"><acronym title="Italiano"><img src="../images/it.png" alt="Italiano" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.ko"><acronym title="&#54620;&#44397;&#50612;&nbsp;(Hangul)"><img src="../images/ko.png" alt="&#54620;&#44397;&#50612;&nbsp;(Hangul)" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.pl"><acronym title="polski"><img src="../images/pl.png" alt="polski" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.ru"><acronym title="&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)"><img src="../images/ru.png" alt="&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-relay.html.zh-cn"><acronym title="&#20013;&#25991;(&#31616;) (Simplified Chinese)"><img src="../images/zh-cn.png" alt="&#20013;&#25991;(&#31616;) (Simplified Chinese)" width="24" height="16"></acronym></a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Configurer un relais Tor</h1>
<!-- BEGIN SIDEBAR -->
<div class="sidebar-left">
<h3>Étapes de configuration</h3>
<ol>
<li><a href="../docs/tor-doc-relay.html.fr#install">Télécharger &amp; Installer</a></li>
<li><a href="../docs/tor-doc-relay.html.fr#setup">Configurer</a></li>
<li><a href="../docs/tor-doc-relay.html.fr#check">Vérifier &amp; Confirmer</a></li>
<li><a href="../docs/tor-doc-relay.html.fr#after">Étape finale</a></li>
</ol>
</div>
<!-- END SIDEBAR -->
<p>
Le réseau Tor repose sur des contributeurs qui offrent de leur bande passante. Plus
il y aura de personnes à faire tourner un relais, plus le réseau sera rapide. Si vous avez
au moins 20 kilo-octets/s dans chaque sens, aidez Tor en le configurant
comme relais. Nous avons plusieurs options qui rendent l'usage de Tor facile
et agréable, par exemple la limitation de bande passante consommée, le contrôle sur ports de sortie
pour que vous puissiez limiter votre exposition aux plaintes, et le support des
adresses IP dynamiques.</p>
<p>Avoir des relais dans plein de lieux différents sur Internet c'est
ce qui sécurise les utilisateurs. <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ServerAnonymity">Vous
auriez également d'avantage d'anonymat</a>,
puisque les sites distants ne pourraient pas savoir si une connexion vient de votre
ordinateur ou si elle est relayée d'un autre.</p>
<p>Paramétrer un relais Tor est facile et commode :
<ul>
<li>Tor a des fonctions intégrées pour <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#LimitBandwidth">la limitation
de bande passante</a>. De plus, si vous avez une ligne rapide
mais souhaitez limiter le nombre d'octets échangés que vous offrez par jour
( semaine ou mois) , regardez la fonctionnalité d'<a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Hibernation">hibernation
</a>.
</li>
<li>Chaque relais Tor a <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RunAServerBut">une politique
de sortie</a> qui spécifie quelles sortes de trafic sortantes sont autorisées
ou refusées depuis ce relais. Si vous êtes gêné à l'idée de laisser des gens
sortir par votre connexion, vous pouvez paramétrer Tor pour qu'il ne se connecte
qu'à d'autres relais Tor.
</li>
<li>Ce n'est pas grave que le relais soit coupé de temps en temps. Les annuaires
le notent rapidement et stoppent la propagation du relais. Assurez vous simplement
que ça n'arrive pas trop souvent, puisque les connexions en cours dans le
relais seront coupées.
</li>
<li>Nous pouvons prendre en compte les relais avec une adresse IP dynamique &mdash; veillez
simplement à laisser l'option de configuration « Address » à vide, et Tor essayera de la deviner.
</li>
<li>Si votre relais est derrière un NAT et qu'il ne connait pas son adresse IP
publique (par exemple si l'IP est 192.168.x.y), vous aurez à paramétrer une
translation de port. La translation de port est dépendante du système mais cette <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ServerForFirewalledClients">entrée
de la FAQ</a> offre quelques exemples sur comment le faire.
</li>
<li>Votre relais va de manière passive estimer et propager sa capacité récente
en terme de bande passante, ainsi les relais à fort débit attireront davantage d'utilisateurs que
ceux en ayant un faible. Bien qu'avoir un relais à petit débit soit tout de même utile.
</li>
</ul>
<p>Vous pouvez faire tourner un relais Tor sur
pratiquement n'importe quel système, mais voyez <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ServerOS">cette
entrée de la FAQ</a> pour vous documenter sur ceux qui fontionnent le mieux et les différents problèmes
que vous seriez suceptibles de rencontrer.</p>
<hr>
<a id="zero"></a>
<a id="install"></a>
<h2><a class="anchor" href="#install">Étape une : télécharger et installer Tor</a></h2>
<br>
<p>Avant de commencer, vous devez vous assurer que Tor fonctionne correctement.
</p>
<p>Pour les utilisateurs Windows, ceci signifie qu'au moins <a
href="../docs/tor-doc-windows.html.fr#installing">l'étape une</a>
du Guide d'installation de Tor sous Windows est faite. Les utilisateurs de Mac OS X doivent au moins avoir fait
<a href="../docs/tor-doc-osx.html.fr#installing">l'étape une</a>
du Guide d'installation de Tor sous OS X. Les utilisateurs Linux/BSD/Unix devraient au moins avoir fait
<a href="../docs/tor-doc-unix.html.fr#installing">l'étape une</a>
du guide d'installation de Tor sous Unix.
</p>
<p>Si ça vous dit, vous pouvez également l'utiliser comme client pendant
quelques temps pour savoir si ça fonctionne réellement.</p>
<hr>
<a id="setup"></a>
<h2><a class="anchor" href="#setup">Étape deux : le paramétrer comme relais</a></h2>
<br>
<ol>
<li>Verifiez que votre horloge est à l'heure. Si possible, synchronisez là
sur un serveur de temps public.
</li>
<li>Assurez-vous que les résolutions de nom fonctionnent (c'est à dire que, votre ordinateur est
en mesure de résoudre les adresses Internet correctement).
</li>
<li>La manière la plus simple de configurer un relai est d'utiliser Vidalia. La manière la plus avancée est d'éditer votre torrc directement.
<ul><strong>Configuration facile</strong>:
<li>Clickez droit sur l'icône Vidalia dans votre barre des tâches. Choisissez <tt>Panneau de contrôle</tt>.</li>
<li>Clickez sur <tt>Configurer un relai</tt>.</li>
<li>Choisir <tt>Relayer le trafic pour le réseau Tor</tt>.</li>
<li>Entrer un nickname pour votre relai. (Optionnellement, vos informations de contact.)</li>
<li>Choisissez <tt>tenter de configurer automatiquement la translation de port</tt>.
Appuyez sur le boutton <tt>Test</tt> pour voir si ça marche. Si ça fonctionne, super.
Si non, voyez le point 4 ci-dessous.</li>
<li>Choisisser le panneau <tt>Limitation de bande passante</tt>. Sélectionnez combien de bande passante vous souhaitez apporter aux utilisateurs comme à vous même.</li>
<li>Choisissez le panneau <tt>Politique de sortie</tt>. Si vous souhaitez autoriser d'autres personnes
à utiliser votre relais pour ces services, ne changez rien. Décochez les services
que vous ne souhaitez pas autoriser à travers votre relais. Si vous ne souhaitez pas être un relais de sortie
décochez tous les services.</li>
<li>Cliquez sur le boutton <tt>Valider</tt>. Voyez l'étape deux pour la confirmation
que votre relais fonctionne correctement.</li>
</li>
<strong>Configuration avancée</strong>:
<li>Éditez la partie basse de votre torrc. (See <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#torrc">cette entrée
de la FAQ</a> pour l'aide.)
Assurez vous de définir au moins les options Nickname et ORPort. Créez un DataDirectory
si nécessaire, et prenez soin de lui attribuer les droits de l'utilisateur qui fera tourner
Tor. <em>Si vous souhaitez faire tourner plus d'un relais, c'est possible, mais
prenez soin de positionner l'option <a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#MultipleServers">
MyFamily</a> sur l'ensemble de vos fichiers de configurations relais.</em></li>
</li>
</ul>
<li> Si vous utilisez un pare-feu, ouvrez le port tel que les
connections entrantes puissent atteindre le port que vous avez configuré (ORPort, et
DirPort si vous l'avez activé). Assurez vous qu'il autorise toutes les connections sortantes
pour que votre relais puisse atteindre les autres relais Tor.
</li>
<li>
Relancer votre relais. S'il <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">trace</a>
n'importe quel dysfonctionnement, faites nous en part.
</li>
<li>
Inscrivez vous à la liste de diffusion <a
href="http://archives.seul.org/or/announce/">or-announce</a>.
Il y a relativement peu de messages, et vous tiendra informé
des nouvelles versions stables. Vous devriez aussi envisager de vous inscrire à <a
href="http://archives.seul.org/or/talk/">or-talk</a> (davantage de messages),
où les versions de développement sont annoncées.
</li>
<li>
Jetez un œil sur le manuel.
Le <a href="../tor-manual.html">manuel</a> pour la
dernière version stable contient une liste de toutes les options de configuration possible pour,
à la fois, les clients et les relais.
Si vous utilisez la version de développement de Tor, le manuel est disponible
<a href="../tor-manual-dev.html">ici</a>.
</li>
</ol>
<hr>
<a id="check"></a>
<h2><a class="anchor" href="#check">Étape trois : assurez vous que ça fonctionne</a></h2>
<br>
<p>Dès que votre relais va tenter de se connecter au réseau, il va
essayer de déterminer si le port que vous avez configuré est joignable de
l'extérieur. Ceci peut prendre jusqu'à 20 minutes. Jetez un œil sur les
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#Logs">traces
</a> du genre
<tt>Self-testing indicates your ORPort is reachable from the outside. Excellent.</tt>
Si vous ne voyez pas ce message, ça signifie que votre relais n'est pas joignable
de l'extérieur &mdash; vous devriez revérifier vos pare-feux, vérifier qu'il
teste l'adresse IP et le port que vous penser qu'il devrait tester, etc.
</p>
<p>Quand votre relais est joignable, il envoie un « descripteur
de relais » aux annuaires. Ceci permettra aux clients de connaitre
quelle adresse, ports, clé, etc votre relais utilise. Vous pouvez <a
href="http://moria.seul.org:9032/tor/status/authority">charger l'un des états
du réseau</a> et
voir si vous trouvez dedans le nom que vous avez configuré, pour être certain qu'il
est là. Vous aurez probablement à attendre quelques secondes pour avoir un
rafraichissement du répertoire.</p>
<hr>
<a id="after"></a>
<h2><a class="anchor" href="#after">Étape quatre : une fois que ça marche</a></h2>
<br>
<p>
Nous recommandons tout aussi bien les étapes suivantes :
</p>
<p>
8. Lisez
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/OperationalSecurity">ce document</a>
pour avoir des idées sur comment accroitre la sécurité de votre relais.
</p>
<p>
9. Décidez quelle politique de sortie vous souhaitez. Par défaut, votre relais autorise
l'accès à plusieurs services populaires, mais en restreint certains (comme le port 25)
en raison des abus potentiels. Vous pouvez préférer une politique de sortie qui soit
plus ou moins restrictive ; éditez votre fichier torrc de manière appropriée.
Lisez l'entrée de la FAQ sur les <a
href="../faq-abuse.html.fr#TypicalAbuses">les problèmes que vous seriez suceptible
de rencontrer si vous utilisez la politique par défaut</a>.
Si vous choisissez une politique de sortie particulièrement ouverte, assurez vous
que votre fournisseur d'accès est d'accord avec ce choix.
S'il y a des ressources que votre ordinateur ne peut atteindre (par exemple,
vous êtes derrière un pare-feu restrictif ou un filtrage applicatif, prenez soin
de les rejeter explicitement dans votre politique de sortie &mdash; sinon les utilisateurs de Tor
seront également impactés.
</p>
<p>
10. Décidez de la limitation de débit. Le cable, les xDSL, et les utilisateurs
qui ont une bande passante asymétrique (par exemple : plus de débit en téléchargement qu'en envoi) doivent
limiter leur débit à la plus petite bande passante pour éviter les congestions. Voyez l'entrée <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#LimitBandwidth">FAQ sur
la limitation du débit</a> pour plus de détails.
</p>
<p>
11. Sauvegardez la clé privée de votre relais Tor (stockée dans "keys/secret_id_key"
de votre DataDirectory). C'est l'« identité » de votre relais, et
prenez soin de la garder en sécurité pour que personne ne puisse lire le trafic qui passe
au travers de votre nœud. C'est un fichier critique à conserver si vous compter <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#UpgradeServer">déplacer
ou restorer votre relais Tor</a> si quelque chose se passe mal.
</p>
<p>
12. Si vous contrôlez le serveur de nom de votre domaine, n'hésitez pas à
paramétrer votre nom d'hôte avec 'anonymous' or 'proxy' or 'tor-proxy', pour que les
autres personnes voyant l'adresse dans les traces web puissent facilement comprendre
ce qui se passe.
Ajouter une <a
href="https://tor-svn.freehaven.net/svn/tor/trunk/contrib/tor-exit-notice.html">Note de Sortie Tor</a> sur un hôte virtuel du même nom peut simplement décourager l'envoi de plaintes à vous
  et votre fournisseur d'accès Internet si vous utilisez un noeud de sortie.
<p>
13. Si votre ordinateur ne fait pas tourner un serveur web, envisagez de
changer l'option ORPort à 443 et votre DirPort à 80. Un certain nombre d'utilisateurs
 Tor sont cloitrés derrière des pare-feux qui ne leur permettent que d'aller sur le
web, et ce changement leur permettra d'atteindre votre relais Tor. Les relais
Windows peuvent simplement changer leurs options ORPort et DirPort directement
dans leur configuration torrc et relancer Tor. Les relais OS X ou Unix ne peuvent pas attacher
directement ces ports (puisqu'ils doivent être lancé en root), alors ils doivent
paramétrer une sorte de <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ServerForFirewalledClients">
translation de port</a> pour que les connections puissent atteindre leur relais Tor. Si vos ports
80 et 443 sont déjà utilisés mais que vous souhaitez quand même aider, d'autres sont interessants comme
les ports 22, 110, et 143.
</p>
<p>
14. Si votre relais Tor apporte d'autres services sur la même adresse IP
&mdash; comme par exemple un site web &mdash; assurez vous que les connexions
au serveur web sont autorisées à partir de l'hôte local également. Vous devez faire ça
parceque les clients Tor détecteront que le relais Tor est le <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ExitEavesdroppers">le chemin
le plus sûr pour atteindre le serveur web</a>, et construira toujours un chemin qui finira
par votre relais. Si vous ne souhaitez pas autoriser les connexions, vous devrez
explicitement les rejeter dans votre politique de sortie.
</p>
<p>
15. (Unix uniquement). Créer un utilisateur séparé pour faire tourner le relais. Si vous
installez le paquet OS X ou deb ou rpm, ceci est déjà
fait. Sinon, vous devez le faire à la main. (Le relais Tor ne nécessite pas d'être
lancé sous root, c'est une bonne pratique de ne pas le faire. Le lancer
sous l'utilisateur 'tor' évite les problèmes avec identd et d'autres services qui
détectent le nom d'utilisateur. Si vous êtes dans le genre paranoïaque, sentez vous libre de <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorInChroot">mettre Tor
dans une prison chroot</a>.)
</p>
<p>
16. (Unix uniquement.) Votre système d'exploitation limite probablement le nombre
de fichier ouvert par processus à 1024 (voir moins). Si vous
envisagez de faire tourner un nœud de sortie rapide, ceci ne sera sans doute pas suffisant. Sous
Linux, vous ajoutez une ligne genre "toruser hard nofile 8192" à votre fichier
/etc/security/limits.conf (ou toruser est l'utilisateur qui fait tourner le
processus Tor), et ensuite relancer Tor s'il est installé comme paquet (ou déconnectez vous
puis reconnectez vous si vous le lancez par vous même).
</p>
<p>
17. Si vous installez Tor à partir d'une installation automatisée, il le lance probablement
automatiquement pour vous au démarrage du système. Mais si vous l'installez par les sources,
vous trouverez sûrement les scripts de démarrage situés dans contrib/tor.sh ou contrib/torctl utiles.
</p>
<p>
Quand vous changez la configuration de votre Tor,
assurez vous qu'il fonctionne encore après les modifications.
Assurez vous de bien positionner votre ligne « ContactInfo » dans le fichier torrc
pour que nous puissions vous contacter en cas de mise à jour ou si quelque chose se passait mal.
Si vous avez des problèmes ou des questions, voyez
la <a href="../documentation.html.fr#Support">section d'aide</a> ou
<a href="../contact.html.fr">contactez nous</a> sur la liste tor-ops. Merci
de nous aider à faire croître le réseau Tor !
</p>
<hr>
<p>Si vous avez des commentaires pour étoffer ce document, n'hésitez pas <a
href="../contact.html.fr">à nous en faire part</a>. Merci !</p>
  </div><!-- #main -->
</div>
<hr>
</div>
  <div class="bottom" id="bottom">
     <p>"Tor" et le Logo Onion sont des <a href="../trademark-faq.html.fr">marques déposées</a> du Projet Tor, Inc.
     </p>
     <p>
      Attention: Cette traduction peut être obsolète. La version anglaise originale est la
      21098 alors que la version traduite est basée sur la
      18753.
     </p>
     <p>
       Cette page est aussi disponible dans les langues suivantes :
       <a href="tor-doc-relay.html.de">Deutsch</a>, <a href="tor-doc-relay.html.en">English</a>, <a href="tor-doc-relay.html.es">espa&ntilde;ol</a>, <a href="tor-doc-relay.html.it">Italiano</a>, <a href="tor-doc-relay.html.ko">&#54620;&#44397;&#50612;&nbsp;(Hangul)</a>, <a href="tor-doc-relay.html.pl">polski</a>, <a href="tor-doc-relay.html.ru">&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)</a>, <a href="tor-doc-relay.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Comment configurer la <a href="http://www.debian.org/intro/cn#howtoset">langue par défaut du document</a>.
      </p>
      <p>Les développeurs de Tor n'ont pas revu cette traduction en ce qui concerne la
      pertinence et l'exactitude. Elle peut être obsolète ou fausse. La version
      officielle du site web Tor est la version anglaise, disponible sur <a
      href="https://www.torproject.org/">https://www.torproject.org/</a>.
      </p>
      <p>
      <i><a href="../contact.html.fr" class="smalllink">Webmaster</a></i> -
  	       Dernière modification : Mon Mar 16 11:46:57 2009
  	       -
  	       Dernière mise à jour : Thu Dec 17 08:19:19 2009
  	      </p>
  </div>
</body>
</html>
