/* Tower Toppler - Nebulus
 * Copyright (C) 2000-2006  Andreas Rver
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef MENU_H
#define MENU_H

#include "decl.h"

#include <SDL_types.h>
#include <SDL_keyboard.h>

#include "menusys.h"

/* load graphics */
void men_init();

/* the main menu */
void men_main();

/* free graphics */
void men_done();

#ifdef GAME_DEBUG_KEYS
void run_debug_menu();
#endif

/* menu shown to user when he presses esc during play */
bool men_game();

/* asks a yes/no question; return 0 if "no",
   1 if "yes" */
unsigned char men_yn(char *s, bool defchoice, menuopt_callback_proc pr = 0);


/* shows string s, waits a certain time, (-1 = indefinitely),
   and if fire = 1 -> "press fire", if fire = 2 -> "press space" */
void men_info(const char *s, long timeout = -1, int fire = 0);

/* input line; asks the user for a string.
 * 
 * This function returns immediately, and the return
 * value tells whether the user finished editing the string.
 */
bool men_input(char *origs, int max_len, int xpos = -1,
               int ypos = (SCREENHEI  * 2) / 3,
               const char *allowed = NULL);


#endif
