#ifndef AUTHENTICATIONDIALOG_H
#define AUTHENTICATIONDIALOG_H

#include "abstractdialog.h"
#include "token.h"

class QLineEdit;
class QScrollArea;
class QDialogButtonBox;
class QGridLayout;

using namespace QtUbuntuOne;

class AuthenticationDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit AuthenticationDialog(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onCredentialsChanged();
    void authenticate();
    void onTokenReady(Token *token);
    
private:
    QLineEdit *m_emailEdit;
    QLineEdit *m_passwordEdit;
    QLineEdit *m_otpEdit;

    QDialogButtonBox *m_buttonBox;
    QPushButton *m_button;

    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // AUTHENTICATIONDIALOG_H
