#ifndef SELECTIONMODEL_H
#define SELECTIONMODEL_H

#include <QStandardItemModel>

class SelectionRoles : public QObject
{
    Q_OBJECT

    Q_ENUMS(Role)

public:
    enum Role {
        NameRole = Qt::DisplayRole,
        ValueRole = Qt::UserRole + 1
    };
};

class SelectionModel : public QStandardItemModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit SelectionModel(QObject *parent = 0);
    ~SelectionModel();

#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    Q_INVOKABLE void addItem(const QString &name, const QVariant &value);

signals:
    void countChanged(int count);

protected:
    QHash<int, QByteArray> m_roleNames;
};

#endif // SELECTIONMODEL_H
