#include "notifications.h"
#ifdef Q_WS_MAEMO_5
#include "../maemo5/windowstack.h"
#include "../maemo5/stackedwindow.h"
#include <QMaemo5InformationBox>
#endif

Notifications* Notifications::m_instance = 0;

Notifications::Notifications() :
    QObject()
{
    if (!m_instance) {
        m_instance = this;
    }
}

Notifications::~Notifications() {}

Notifications* Notifications::instance() {
    return !m_instance ? new Notifications : m_instance;
}

void Notifications::showInformation(const QString &message) {
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(WindowStack::instance()->currentWindow(), message);
#else
    if (m_instance) {
        emit m_instance->information(message);
    }
#endif
}

void Notifications::showError(const QString &message) {
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(WindowStack::instance()->currentWindow(), message, 0);
#else
    if (m_instance) {
        emit m_instance->error(message);
    }
#endif
}
