#include "selectionmodel.h"

SelectionModel::SelectionModel(QObject *parent) :
    QStandardItemModel(parent)
{
    m_roleNames[SelectionRoles::NameRole] = "name";
    m_roleNames[SelectionRoles::ValueRole] = "value";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif
}

SelectionModel::~SelectionModel() {}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> SelectionModel::roleNames() const {
    return m_roleNames;
}
#endif

void SelectionModel::addItem(const QString &name, const QVariant &value) {
    QStandardItem *item = new QStandardItem(name);
    item->setTextAlignment(Qt::AlignCenter);
    item->setData(value, SelectionRoles::ValueRole);
    this->appendRow(item);
    emit countChanged(this->rowCount());
}
