#include "windowstack.h"
#include "stackedwindow.h"

WindowStack* WindowStack::m_instance = 0;

WindowStack::WindowStack() :
    QObject()
{
    if (!m_instance) {
        m_instance = this;
    }
}

WindowStack::~WindowStack() {}

WindowStack*  WindowStack::instance() {
    return !m_instance ? new WindowStack : m_instance;
}

StackedWindow* WindowStack::currentWindow() const {
    return m_windowStack.isEmpty() ? 0 : m_windowStack.last();
}

StackedWindow* WindowStack::rootWindow() const {
    return m_windowStack.isEmpty() ? 0 : m_windowStack.first();
}

void WindowStack::addWindowToStack(StackedWindow *window) {
    m_windowStack.append(window);
    emit currentWindowChanged(this->currentWindow());
}

void WindowStack::removeWindowFromStack(StackedWindow *window) {
    m_windowStack.removeOne(window);
    emit currentWindowChanged(this->currentWindow());
}

void WindowStack::unwindWindowStack() {
    for (int i = m_windowStack.size() - 1; i > 0; i--) {
        m_windowStack.at(i)->close();
    }

    emit currentWindowChanged(this->currentWindow());
}
