#ifndef STACKEDWINDOW_H
#define STACKEDWINDOW_H

#include "session.h"
#include <QMainWindow>

class StackedWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit StackedWindow(QWidget *parent = 0);
    explicit StackedWindow(Session *session, QWidget *parent);
    ~StackedWindow() {}
    inline bool inPortrait() const { return m_portrait; }

protected slots:
    void setOrientation(ScreenOrientation::Orientation orientation);
    void onOrientationChanged();
    void toggleBusy(bool busy);

protected:
    inline virtual void setLandscapeLayout() {}
    inline virtual void setPortraitLayout() {}

protected:
    Session *m_session;

private:
    bool m_portrait;
};

#endif // STACKEDWINDOW_H
