#include "transferlistdelegate.h"
#include "transferlistmodel.h"
#include "utils.h"
#include <QStyleOptionProgressBar>
#include <QApplication>

TransferListDelegate::TransferListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 5);
    textRect.setRight(textRect.right() - 160);
    textRect.setTop(textRect.top() + 5);
    textRect.setHeight(30);

    painter->drawText(textRect, Qt::TextWordWrap, index.data(TransferListModel::FileNameRole).toString());


    QFont oldFont = painter->font();
    QFont smallFont;
    smallFont.setPixelSize(18);
    painter->setFont(smallFont);

    textRect.moveTop(textRect.bottom());
    textRect.setHeight(40);

    painter->drawText(textRect, Qt::AlignBottom | Qt::TextSingleLine, tr("Priority") + QString(": %1").arg(index.data(TransferListModel::PriorityTextRole).toString()));

    textRect.moveTop(textRect.bottom());

    TransferItem::Status status = static_cast<TransferItem::Status>(index.data(TransferListModel::StatusRole).toInt());

    QPen oldPen = painter->pen();
    QPen statusPen = oldPen;

    if (status == TransferItem::Failed) {
        statusPen.setColor(Qt::red);
    }
    else if (status == TransferItem::Active) {
        statusPen.setColor(QApplication::style()->standardPalette().color(QPalette::Highlight));
    }
    else {
        statusPen.setColor(QColor("#4d4d4d"));
    }

    painter->setPen(statusPen);

    if ((status == TransferItem::Paused) || (status == TransferItem::Queued)) {
        painter->drawText(textRect, Qt::AlignBottom | Qt::TextSingleLine, index.data(TransferListModel::StatusTextRole).toString());
    }
    else {
        painter->drawText(textRect, Qt::AlignBottom | Qt::TextSingleLine, QString("%1: %2").arg(index.data(TransferListModel::StatusTextRole).toString()).arg(status == TransferItem::Active
                                                                                                                                                         ? Utils::durationFromMSecs(index.data(TransferListModel::EtaRole).toInt())
                                                                                                                                                         : index.data(TransferListModel::StatusInfoRole).toString()));
    }

    painter->setPen(oldPen);
    painter->setFont(oldFont);

    QRect progressRect = option.rect;
    progressRect.setLeft(progressRect.right() - 155);
    progressRect.setWidth(150);
    progressRect.setTop(progressRect.top() + 15);
    progressRect.setBottom(progressRect.bottom() - 15);

    int progress = int (index.data(TransferListModel::ProgressRole).toFloat() * 100);

    QStyleOptionProgressBar progressBar;
    progressBar.rect = progressRect;
    progressBar.minimum = 0;
    progressBar.maximum = 100;
    progressBar.progress = progress;
    progressBar.text = QString::number(progress) + "%";
    progressBar.textVisible = true;

    QApplication::style()->drawControl(QStyle::CE_ProgressBar, &progressBar, painter);

}

QSize TransferListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 120);
}
