#include "transferitem.h"

TransferItem::TransferItem(QObject *parent) :
    QObject(parent),
    m_type(Download),
    m_status(Paused),
    m_priority(NormalPriority),
    m_progress(0.0),
    m_eta(0),
    m_size(0),
    m_publish(false)
{
}

TransferItem::TransferItem(const QString &key, TransferType type, Status status, Priority priority, QObject *parent) :
    QObject(parent),
    m_key(key),
    m_type(type),
    m_status(status),
    m_priority(priority),
    m_progress(0.0),
    m_eta(0),
    m_size(0),
    m_publish(false)
{
}

QString TransferItem::statusText() const {
    switch (status()) {
    case Queued:
        return tr("Queued");
    case Paused:
        return tr("Paused");
    case Active:
        return tr("In progress");
    case Cancelled:
        return tr("Cancelled");
    case Failed:
        return tr("Failed");
    default:
        return QString();
    }
}

QString TransferItem::priorityText() const {
    switch (priority()) {
    case HighPriority:
        return tr("High");
    case NormalPriority:
        return tr("Normal");
    case LowPriority:
        return tr("Low");
    default:
        return QString();
    }
}
