/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.gui.tree;

import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.kxml2.kdom.Element;
import to_do_o.core.config.SWTConstants;
import to_do_o.core.data.SWTToDoDocument;
import to_do_o.core.settings.SettingsStoreSingleton;
import to_do_o.gui.dnd.ToDoOTransfer;
import to_do_o.gui.listener.FitItemTextListenerLinux;
import to_do_o.gui.tree.AbstractItem;
import to_do_o.gui.tree.ToDoTree;

public final class SWTToDoTree
extends ToDoTree {
    public SWTToDoTree(Composite parent) {
        super(parent);
    }

    @Override
    protected final void preLoad() {
        if (this.tree != null) {
            this.tree.dispose();
        }
        this.doc = new SWTToDoDocument();
    }

    @Override
    protected final void addListeners() {
        super.addListeners();
        if (!SWTConstants.IS_HILDON && SettingsStoreSingleton.getInstance().getBoolean("EnableDragAndDrop")) {
            SWTToDoTree sWTToDoTree = this;
            Transfer[] transferArray = new Transfer[]{ToDoOTransfer.getInstance()};
            DragSource dragSource = new DragSource((Control)sWTToDoTree.getTree(), 2);
            dragSource.setTransfer(transferArray);
            dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(sWTToDoTree){
                private TreeItem sourceItem;
                private /* synthetic */ SWTToDoTree this$0;
                {
                    this.this$0 = sWTToDoTree;
                }

                public final void dragStart(DragSourceEvent e) {
                    e.doit = false;
                    this.sourceItem = null;
                    TreeItem currentItem = this.this$0.getSelection().getTreeItem();
                    if (!(currentItem instanceof TreeItem)) {
                        return;
                    }
                    this.sourceItem = currentItem;
                    e.doit = true;
                }

                public final void dragSetData(DragSourceEvent e) {
                    if (this.sourceItem == null || !(this.sourceItem.getData() instanceof AbstractItem)) {
                        return;
                    }
                    e.data = this.sourceItem.getData();
                }

                public final void dragFinished(DragSourceEvent e) {
                    if (e == null || !e.doit || this.sourceItem == null || !(this.sourceItem.getData() instanceof AbstractItem) || e.detail == 0) {
                        return;
                    }
                    ((AbstractItem)this.sourceItem.getData()).delete();
                }
            });
            dragSource = new DropTarget((Control)sWTToDoTree.getTree(), 2);
            dragSource.setTransfer(transferArray);
            dragSource.addDropListener((DropTargetListener)new DropTargetAdapter(sWTToDoTree){
                private /* synthetic */ SWTToDoTree this$0;
                {
                    this.this$0 = sWTToDoTree;
                }

                public final void dragOver(DropTargetEvent e) {
                    e.feedback = 28;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final void drop(DropTargetEvent dropTargetEvent) {
                    if (!(dropTargetEvent.data instanceof Element)) {
                        dropTargetEvent.detail = 0;
                        return;
                    }
                    Element element = (Element)dropTargetEvent.data;
                    if (!(dropTargetEvent.item instanceof TreeItem)) {
                        Tree tree = this.this$0.getTree();
                        AbstractItem.newInstance(element, (Widget)tree, 0);
                        return;
                    }
                    TreeItem treeItem = (TreeItem)dropTargetEvent.item;
                    TreeItem treeItem2 = treeItem.getParentItem();
                    if (treeItem2 == null) {
                        dropTargetEvent = treeItem.getParent();
                        AbstractItem.newInstance(element, (Widget)dropTargetEvent, dropTargetEvent.indexOf(treeItem) + 1);
                        SWTToDoTree.updateXMLStructure(dropTargetEvent.indexOf(treeItem), element, this.this$0.doc.getRootElement());
                        return;
                    }
                    if (!this.isOwnChild(element, treeItem2)) {
                        AbstractItem.newInstance(element, (Widget)treeItem2, treeItem2.indexOf(treeItem) + 1);
                        SWTToDoTree.updateXMLStructure(treeItem2.indexOf(treeItem), element, ((AbstractItem)treeItem2.getData()).getElement());
                        return;
                    }
                    dropTargetEvent.detail = 0;
                }

                private boolean isOwnChild(Element element, TreeItem treeItem) {
                    while (treeItem != null) {
                        if (!(treeItem.getData() instanceof AbstractItem)) {
                            return false;
                        }
                        AbstractItem abstractItem = (AbstractItem)treeItem.getData();
                        if (this.elementsEqual(element, (Element)(abstractItem = abstractItem.getElement()))) {
                            return true;
                        }
                        treeItem = treeItem.getParentItem();
                    }
                    return false;
                }

                private boolean elementsEqual(Element element, Element element2) {
                    if (element.getChildCount() != element2.getChildCount()) {
                        return false;
                    }
                    boolean bl = false;
                    for (int i = 0; i < element.getChildCount(); ++i) {
                        Object object = element.getChild(i);
                        Object object2 = element2.getChild(i);
                        bl = object instanceof Element && object2 instanceof Element ? this.elementsEqual((Element)object, (Element)object2) : object.equals(object2);
                        if (!bl) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        if (!SWTConstants.IS_WINDOWS && SettingsStoreSingleton.getInstance().getBoolean("AutoBreakLines")) {
            this.tree.addListener(42, (Listener)new FitItemTextListenerLinux());
        }
    }
}

