/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.asymmetric.ec;

import java.math.BigInteger;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.math.ec.ECCurve;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import to_do_o.core.settings.SettingsStoreSingleton;

public class EC5Util {
    private MessageBox mb;
    private int answer;

    public EC5Util() {
    }

    public static EllipticCurve convertCurve$3bd7a276(ECCurve eCCurve) {
        if (eCCurve instanceof ECCurve.Fp) {
            return new EllipticCurve(new ECFieldFp(((ECCurve.Fp)eCCurve).getQ()), eCCurve.getA().toBigInteger(), eCCurve.getB().toBigInteger(), null);
        }
        ECCurve.F2m f2m = (ECCurve.F2m)eCCurve;
        if (f2m.isTrinomial()) {
            int[] nArray = new int[]{f2m.getK1()};
            return new EllipticCurve(new ECFieldF2m(f2m.getM(), nArray), eCCurve.getA().toBigInteger(), eCCurve.getB().toBigInteger(), null);
        }
        int[] nArray = new int[]{f2m.getK3(), f2m.getK2(), f2m.getK1()};
        return new EllipticCurve(new ECFieldF2m(f2m.getM(), nArray), eCCurve.getA().toBigInteger(), eCCurve.getB().toBigInteger(), null);
    }

    public static ECCurve convertCurve(EllipticCurve object) {
        Object object2 = ((EllipticCurve)object).getField();
        BigInteger bigInteger = ((EllipticCurve)object).getA();
        object = ((EllipticCurve)object).getB();
        if (object2 instanceof ECFieldFp) {
            return new ECCurve.Fp(((ECFieldFp)object2).getP(), bigInteger, (BigInteger)object);
        }
        object2 = (ECFieldF2m)object2;
        int n = ((ECFieldF2m)object2).getM();
        object2 = ((ECFieldF2m)object2).getMidTermsOfReductionPolynomial();
        int[] nArray = new int[3];
        if (((Object)object2).length == 1) {
            nArray[0] = (int)object2[0];
        } else {
            if (((Object)object2).length != 3) {
                throw new IllegalArgumentException("Only Trinomials and pentanomials supported");
            }
            if (object2[0] < object2[1] && object2[0] < object2[2]) {
                nArray[0] = (int)object2[0];
                if (object2[1] < object2[2]) {
                    nArray[1] = (int)object2[1];
                    nArray[2] = (int)object2[2];
                } else {
                    nArray[1] = (int)object2[2];
                    nArray[2] = (int)object2[1];
                }
            } else if (object2[1] < object2[2]) {
                nArray[0] = (int)object2[1];
                if (object2[0] < object2[2]) {
                    nArray[1] = (int)object2[0];
                    nArray[2] = (int)object2[2];
                } else {
                    nArray[1] = (int)object2[2];
                    nArray[2] = (int)object2[0];
                }
            } else {
                nArray[0] = (int)object2[2];
                if (object2[0] < object2[1]) {
                    nArray[1] = (int)object2[0];
                    nArray[2] = (int)object2[1];
                } else {
                    nArray[1] = (int)object2[1];
                    nArray[2] = (int)object2[0];
                }
            }
        }
        object2 = nArray;
        return new ECCurve.F2m(n, (int)object2[0], (int)object2[1], (int)object2[2], bigInteger, (BigInteger)object);
    }

    public static org.bouncycastle.jce.spec.ECParameterSpec convertSpec(ECParameterSpec eCParameterSpec, boolean bl) {
        ECCurve eCCurve = EC5Util.convertCurve(eCParameterSpec.getCurve());
        return new org.bouncycastle.jce.spec.ECParameterSpec(eCCurve, EC5Util.convertPoint(eCCurve, eCParameterSpec.getGenerator(), bl), eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor()), eCParameterSpec.getCurve().getSeed());
    }

    public static org.bouncycastle.math.ec.ECPoint convertPoint(ECCurve eCCurve, ECPoint eCPoint, boolean bl) {
        return eCCurve.createPoint(eCPoint.getAffineX(), eCPoint.getAffineY(), bl);
    }

    public EC5Util(Shell shell, String string) {
        if (SettingsStoreSingleton.getInstance().getBoolean("ConfirmAllActions")) {
            this.mb = new MessageBox(shell, 196);
            this.mb.setText("Confirmation");
            this.mb.setMessage(string);
            this.answer = this.mb.open();
            return;
        }
        this.answer = 64;
    }

    public boolean answerYes() {
        return this.answer == 64;
    }
}

