/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce;

import java.security.BasicPermission;
import java.security.Permission;
import java.util.StringTokenizer;
import org.bouncycastle.util.Strings;

public final class ProviderConfigurationPermission
extends BasicPermission {
    private final String actions;
    private final int permissionMask;

    public ProviderConfigurationPermission(String string, String string2) {
        super(string, string2);
        this.actions = string2;
        this.permissionMask = ProviderConfigurationPermission.calculateMask(string2);
    }

    private static int calculateMask(String object) {
        object = new StringTokenizer(Strings.toLowerCase((String)object), " ,");
        int n = 0;
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            if (string.equals("threadlocalecimplicitlyca")) {
                n |= 1;
                continue;
            }
            if (string.equals("ecimplicitlyca")) {
                n |= 2;
                continue;
            }
            if (!string.equals("all")) continue;
            n |= 3;
        }
        if (n == 0) {
            throw new IllegalArgumentException("unknown permissions passed to mask");
        }
        return n;
    }

    @Override
    public final String getActions() {
        return this.actions;
    }

    @Override
    public final boolean implies(Permission permission) {
        if (!(permission instanceof ProviderConfigurationPermission)) {
            return false;
        }
        if (!this.getName().equals(permission.getName())) {
            return false;
        }
        permission = (ProviderConfigurationPermission)permission;
        return (this.permissionMask & ((ProviderConfigurationPermission)permission).permissionMask) == ((ProviderConfigurationPermission)permission).permissionMask;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ProviderConfigurationPermission) {
            object = (ProviderConfigurationPermission)object;
            return this.permissionMask == ((ProviderConfigurationPermission)object).permissionMask && this.getName().equals(((Permission)object).getName());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.getName().hashCode() + this.permissionMask;
    }
}

