/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x9.X9Curve;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9FieldID;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public final class X9ECParameters
extends ASN1Encodable
implements X9ObjectIdentifiers {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private X9FieldID fieldID;
    private ECCurve curve;
    private ECPoint g;
    private BigInteger n;
    private BigInteger h;
    private byte[] seed;

    public X9ECParameters(ASN1Sequence aSN1Sequence) {
        if (!(aSN1Sequence.getObjectAt(0) instanceof DERInteger) || !((DERInteger)aSN1Sequence.getObjectAt(0)).getValue().equals(ONE)) {
            throw new IllegalArgumentException("bad version in X9ECParameters");
        }
        X9Curve x9Curve = new X9Curve(new X9FieldID((ASN1Sequence)aSN1Sequence.getObjectAt(1)), (ASN1Sequence)aSN1Sequence.getObjectAt(2));
        this.curve = x9Curve.getCurve();
        X9ECPoint x9ECPoint = new X9ECPoint(this.curve, (ASN1OctetString)aSN1Sequence.getObjectAt(3));
        this.g = x9ECPoint.p;
        this.n = ((DERInteger)aSN1Sequence.getObjectAt(4)).getValue();
        this.seed = x9Curve.getSeed();
        if (aSN1Sequence.size() == 6) {
            this.h = ((DERInteger)aSN1Sequence.getObjectAt(5)).getValue();
        }
    }

    public X9ECParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        this(eCCurve, eCPoint, bigInteger, bigInteger2, null);
    }

    public X9ECParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        this.curve = eCCurve;
        this.g = eCPoint;
        this.n = bigInteger;
        this.h = bigInteger2;
        this.seed = byArray;
        if (eCCurve instanceof ECCurve.Fp) {
            this.fieldID = new X9FieldID(((ECCurve.Fp)eCCurve).getQ());
            return;
        }
        if (eCCurve instanceof ECCurve.F2m) {
            eCCurve = (ECCurve.F2m)eCCurve;
            this.fieldID = new X9FieldID(((ECCurve.F2m)eCCurve).getM(), ((ECCurve.F2m)eCCurve).getK1(), ((ECCurve.F2m)eCCurve).getK2(), ((ECCurve.F2m)eCCurve).getK3());
        }
    }

    public final ECCurve getCurve() {
        return this.curve;
    }

    public final ECPoint getG() {
        return this.g;
    }

    public final BigInteger getN() {
        return this.n;
    }

    public final BigInteger getH() {
        if (this.h == null) {
            return ONE;
        }
        return this.h;
    }

    @Override
    public final DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(1));
        aSN1EncodableVector.add(this.fieldID);
        aSN1EncodableVector.add(new X9Curve(this.curve, this.seed));
        aSN1EncodableVector.add(new X9ECPoint(this.g));
        aSN1EncodableVector.add(new DERInteger(this.n));
        if (this.h != null) {
            aSN1EncodableVector.add(new DERInteger(this.h));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

