/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;

public final class DERInteger
extends ASN1Object {
    private byte[] bytes;

    public static DERInteger getInstance(Object object) {
        while (true) {
            if (object == null || object instanceof DERInteger) {
                return (DERInteger)object;
            }
            if (object instanceof ASN1OctetString) {
                return new DERInteger(((ASN1OctetString)object).getOctets());
            }
            if (!(object instanceof ASN1TaggedObject)) break;
            object = ((ASN1TaggedObject)object).getObject();
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERInteger getInstance$573424d4(ASN1TaggedObject aSN1TaggedObject) {
        return DERInteger.getInstance(aSN1TaggedObject.getObject());
    }

    public DERInteger(int n) {
        this.bytes = BigInteger.valueOf(n).toByteArray();
    }

    public DERInteger(BigInteger bigInteger) {
        this.bytes = bigInteger.toByteArray();
    }

    public DERInteger(byte[] byArray) {
        this.bytes = byArray;
    }

    public final BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public final BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    @Override
    final void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(2, this.bytes);
    }

    @Override
    public final int hashCode() {
        int n = 0;
        for (int i = 0; i != this.bytes.length; ++i) {
            n ^= (this.bytes[i] & 0xFF) << i % 4;
        }
        return n;
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERInteger)) {
            return false;
        }
        dERObject = (DERInteger)dERObject;
        return AsymmetricKeyParameter.areEqual(this.bytes, ((DERInteger)dERObject).bytes);
    }

    public final String toString() {
        return this.getValue().toString();
    }
}

