/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RSACoreEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.util.BigIntegers;

public final class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private RSACoreEngine core = new RSACoreEngine();
    private RSAKeyParameters key;
    private SecureRandom random;

    @Override
    public final void init(boolean bl, CipherParameters cipherParameters) {
        this.core.init(bl, cipherParameters);
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            cipherParameters = parametersWithRandom;
            this.key = null;
            cipherParameters = parametersWithRandom;
            this.random = null;
            return;
        }
        this.key = (RSAKeyParameters)cipherParameters;
        this.random = new SecureRandom();
    }

    @Override
    public final int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    @Override
    public final int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    @Override
    public final byte[] processBlock(byte[] object, int n, int n2) {
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        object = this.core.convertInput((byte[])object, n, n2);
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            Object object2 = (RSAPrivateCrtKeyParameters)this.key;
            BigInteger bigInteger = ((RSAPrivateCrtKeyParameters)object2).getPublicExponent();
            if (bigInteger != null) {
                object2 = ((RSAKeyParameters)object2).getModulus();
                BigInteger bigInteger2 = BigIntegers.createRandomInRange(ONE, ((BigInteger)object2).subtract(ONE), this.random);
                object = bigInteger2.modPow(bigInteger, (BigInteger)object2).multiply((BigInteger)object).mod((BigInteger)object2);
                object = this.core.processBlock((BigInteger)object);
                bigInteger = bigInteger2.modInverse((BigInteger)object2);
                object = ((BigInteger)object).multiply(bigInteger).mod((BigInteger)object2);
            } else {
                object = this.core.processBlock((BigInteger)object);
            }
        } else {
            object = this.core.processBlock((BigInteger)object);
        }
        return this.core.convertOutput((BigInteger)object);
    }
}

