/*
 * Decompiled with CFR 0.152.
 */
package ch.elca.el4j.services.xmlmerge.factory;

import ch.elca.el4j.services.xmlmerge.AbstractXmlMergeException;
import ch.elca.el4j.services.xmlmerge.MatchException;
import ch.elca.el4j.services.xmlmerge.Operation;
import ch.elca.el4j.services.xmlmerge.OperationFactory;
import java.util.HashMap;
import java.util.Map;
import org.jaxen.JaxenException;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Element;

public class XPathOperationFactory
implements OperationFactory {
    Map m_map = new HashMap();
    Operation m_defaultOperation;

    public void setOperationMap(Map map) {
        this.m_map = map;
    }

    public void setDefaultOperation(Operation operation) {
        this.m_defaultOperation = operation;
    }

    public Operation getOperation(Element originalElement, Element patchElement) throws AbstractXmlMergeException {
        for (String xPath : this.m_map.keySet()) {
            if (!this.matches(originalElement, xPath) && !this.matches(patchElement, xPath)) continue;
            return (Operation)this.m_map.get(xPath);
        }
        return this.m_defaultOperation;
    }

    private boolean matches(Element element, String xPathString) throws AbstractXmlMergeException {
        if (element == null) {
            return false;
        }
        try {
            JDOMXPath xPath = new JDOMXPath(xPathString);
            boolean result = xPath.selectNodes(element.getParent()).contains(element);
            return result;
        }
        catch (JaxenException e) {
            throw new MatchException(element, (Throwable)e);
        }
    }
}

