/*
 * Decompiled with CFR 0.152.
 */
package ch.elca.el4j.services.xmlmerge.action;

import ch.elca.el4j.services.xmlmerge.AbstractXmlMergeException;
import ch.elca.el4j.services.xmlmerge.Action;
import ch.elca.el4j.services.xmlmerge.DocumentException;
import ch.elca.el4j.services.xmlmerge.Mapper;
import ch.elca.el4j.services.xmlmerge.Matcher;
import ch.elca.el4j.services.xmlmerge.MergeAction;
import ch.elca.el4j.services.xmlmerge.action.AbstractMergeAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class OrderedMergeAction
extends AbstractMergeAction {
    private static Log s_logger = LogFactory.getLog(OrderedMergeAction.class);

    public void perform(Element originalElement, Element patchElement, Element outputParentElement) throws AbstractXmlMergeException {
        s_logger.debug("Merging: " + originalElement + "(List 1) and " + patchElement + "(List 2)");
        Mapper mapper = (Mapper)this.m_mapperFactory.getOperation(originalElement, patchElement);
        if (originalElement == null) {
            outputParentElement.addContent(mapper.map(patchElement));
        } else if (patchElement == null) {
            outputParentElement.addContent((Content)originalElement.clone());
        } else {
            Element workingElement = new Element(originalElement.getName(), originalElement.getNamespacePrefix(), originalElement.getNamespaceURI());
            this.addAttributes(workingElement, originalElement);
            s_logger.debug("Adding " + workingElement);
            outputParentElement.addContent(workingElement);
            this.doIt(workingElement, originalElement, patchElement);
        }
    }

    private void doIt(Element parentOut, Element parentIn1, Element parentIn2) throws AbstractXmlMergeException {
        this.addAttributes(parentOut, parentIn2);
        Content[] list1 = parentIn1.getContent().toArray(new Content[0]);
        Content[] list2 = parentIn2.getContent().toArray(new Content[0]);
        int offsetTreated1 = 0;
        int offsetTreated2 = 0;
        for (int i = 0; i < list1.length; ++i) {
            s_logger.debug("List 1: " + list1[i]);
            if (list1[i] instanceof Comment || list1[i] instanceof Text) {
                parentOut.addContent((Content)list1[i].clone());
                ++offsetTreated1;
                continue;
            }
            if (!(list1[i] instanceof Element)) {
                throw new DocumentException(list1[i].getDocument(), "Contents of type " + list1[i].getClass().getName() + " not supported");
            }
            Element e1 = (Element)list1[i];
            int posInList2 = -1;
            for (int j = offsetTreated2; j < list2.length; ++j) {
                s_logger.debug("List 2: " + list2[j]);
                if (list2[j] instanceof Element) {
                    if (!((Matcher)this.m_matcherFactory.getOperation(e1, (Element)list2[j])).matches(e1, (Element)list2[j])) continue;
                    s_logger.debug("Match found: " + e1 + " and " + list2[j]);
                    posInList2 = j;
                    break;
                }
                if (list2[j] instanceof Comment || list2[j] instanceof Text) continue;
                throw new DocumentException(list2[j].getDocument(), "Contents of type " + list2[j].getClass().getName() + " not supported");
            }
            while (posInList2 != -1 && offsetTreated2 < posInList2) {
                if (list2[offsetTreated2] instanceof Element) {
                    this.applyAction(parentOut, null, (Element)list2[offsetTreated2]);
                } else {
                    Content contentToAdd = (Content)list2[offsetTreated2].clone();
                    parentOut.addContent(contentToAdd);
                }
                ++offsetTreated2;
            }
            if (posInList2 != -1) {
                this.applyAction(parentOut, (Element)list1[offsetTreated1], (Element)list2[offsetTreated2]);
                ++offsetTreated1;
                ++offsetTreated2;
                continue;
            }
            this.applyAction(parentOut, (Element)list1[offsetTreated1], null);
            ++offsetTreated1;
        }
        while (offsetTreated2 < list2.length) {
            if (list2[offsetTreated2] instanceof Element) {
                this.applyAction(parentOut, null, (Element)list2[offsetTreated2]);
            } else {
                Content contentToAdd = (Content)list2[offsetTreated2].clone();
                parentOut.addContent(contentToAdd);
            }
            ++offsetTreated2;
        }
    }

    private void applyAction(Element workingParent, Element originalElement, Element patchElement) throws AbstractXmlMergeException {
        Action action = (Action)this.m_actionFactory.getOperation(originalElement, patchElement);
        Mapper mapper = (Mapper)this.m_mapperFactory.getOperation(originalElement, patchElement);
        if (action instanceof MergeAction) {
            MergeAction mergeAction = (MergeAction)action;
            mergeAction.setActionFactory(this.m_actionFactory);
            mergeAction.setMapperFactory(this.m_mapperFactory);
            mergeAction.setMatcherFactory(this.m_matcherFactory);
        }
        action.perform(originalElement, mapper.map(patchElement), workingParent);
    }

    private void addAttributes(Element out, Element in) {
        Attribute attr;
        int i;
        LinkedHashMap<String, Attribute> allAttributes = new LinkedHashMap<String, Attribute>();
        ArrayList outAttributes = new ArrayList(out.getAttributes());
        ArrayList inAttributes = new ArrayList(in.getAttributes());
        for (i = 0; i < outAttributes.size(); ++i) {
            attr = (Attribute)outAttributes.get(i);
            attr.detach();
            allAttributes.put(attr.getQualifiedName(), attr);
            s_logger.debug("adding attr from out:" + attr);
        }
        for (i = 0; i < inAttributes.size(); ++i) {
            attr = (Attribute)inAttributes.get(i);
            attr.detach();
            allAttributes.put(attr.getQualifiedName(), attr);
            s_logger.debug("adding attr from in:" + attr);
        }
        out.setAttributes(new ArrayList(allAttributes.values()));
    }
}

